/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@I
@Profile+Annotation(value=1)
public class Hashtable<@KeyForBottom K, @KeyForBottom V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry<?, ?>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static final @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable long serialVersionUID = 1421746759512286392L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Collection<V> values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    @FromByteCode
    @FromByteCode
    public Hashtable(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable float var2);

    @FromByteCode
    @FromByteCode
    public Hashtable(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    @FromByteCode
    @FromByteCode
    public Hashtable();

    @FromByteCode
    @FromByteCode
    public @PolyRead Hashtable(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Map<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends K, @KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends V> var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int size(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @PolyRead Enumeration<K> keys(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @PolyRead Enumeration<V> elements(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public synchronized @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    protected void rehash();

    private void addEntry(int var1, K var2, V var3, int var4);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @Nullable V put(@Mutable Hashtable<K, V> this, K var1, V var2);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized @Nullable V remove(@Mutable Hashtable<K, V> this, @UnknownKeyFor @NonNull @Initialized @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized void putAll(@Mutable Hashtable<K, V> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends K, @KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends V> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public synchronized void clear(@AssignsFields Hashtable<K, V> this);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @I(value="N") @org.checkerframework.checker.javari.qual.Mutable Object clone();

    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @ReadOnly String toString(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    private <T> Enumeration<T> getEnumeration(int var1);

    private <T> Iterator<T> getIterator(int var1);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Set<@UnknownKeyFor @NonNull @Initialized @I @org.checkerframework.checker.javari.qual.Mutable Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public synchronized @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly Hashtable<K, V> this);

    @Override
    public synchronized V getOrDefault(Object var1, V var2);

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> var1);

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    @Override
    public synchronized V putIfAbsent(K var1, V var2);

    @Override
    public synchronized boolean remove(Object var1, Object var2);

    @Override
    public synchronized boolean replace(K var1, V var2, V var3);

    @Override
    public synchronized V replace(K var1, V var2);

    @Override
    public synchronized V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    @Override
    public synchronized V computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    @Override
    public synchronized V compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    @Override
    public synchronized V merge(K var1, V var2, BiFunction<? super V, ? super V, ? extends V> var3);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private void reconstitutionPut(Entry<?, ?>[] var1, K var2, V var3) throws StreamCorruptedException;

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Hashtable.this.remove(o) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return super.add(o);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?, ?>[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object, Object> e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?, ?>[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object, Object> e = tab[index];
            Entry<?, ?> prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    e.value = null;
                    ++Hashtable.this.modCount;
                    --Hashtable.this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsValue(o);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        final Entry<?, ?>[] table;
        int index;
        Entry<?, ?> entry;
        Entry<?, ?> lastReturned;
        final int type;
        final boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            Entry<?, ?> e = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public T nextElement() {
            Entry<?, ?> et = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry<?, ?> e = this.lastReturned;
                this.entry = e.next;
                return (T)(this.type == 0 ? e.key : (this.type == 1 ? e.value : e));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry<?, ?>[] tab = Hashtable.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry<Object, Object> e = tab[index];
                Entry<?, ?> prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        ++this.expectedModCount;
                        this.lastReturned = null;
                        ++Hashtable.this.modCount;
                        --Hashtable.this.count;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }
}

