/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite;

import org.cheffo.jeplite.Token;
import org.cheffo.jeplite.TokenMgrError;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    protected static final String eol = System.getProperty("line.separator", "\n");
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public ParseException(Token currentTokenVal, String message) {
        super(message);
        this.specialConstructor = false;
        this.currentToken = currentTokenVal;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = String.valueOf(String.valueOf(expected)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.tokenImage[this.expectedTokenSequences[i][j]])).concat(" "))));
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = String.valueOf(String.valueOf(expected)).concat("...");
            }
            expected = String.valueOf(String.valueOf(expected)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(eol)).concat("    "))));
        }
        String retval = "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = String.valueOf(String.valueOf(retval)).concat(" ");
            }
            if (tok.kind == 0) {
                retval = String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(this.tokenImage[0])));
                break;
            }
            retval = String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(TokenMgrError.addEscapes(tok.image))));
            tok = tok.next;
        }
        retval = this.expectedTokenSequences.length == 1 ? String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("Was expecting:").append(eol).append("    ")))))) : String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("Was expecting one of:").append(eol).append("    "))))));
        retval = String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(expected)));
        return retval;
    }

    public String getErrorInfo() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = String.valueOf(String.valueOf(expected)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.tokenImage[this.expectedTokenSequences[i][j]])).concat(" "))));
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = String.valueOf(String.valueOf(expected)).concat("...");
            }
            expected = String.valueOf(String.valueOf(expected)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(eol)).concat("    "))));
        }
        String retval = "Unexpected \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = String.valueOf(String.valueOf(retval)).concat(" ");
            }
            if (tok.kind == 0) {
                retval = String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(this.tokenImage[0])));
                break;
            }
            retval = String.valueOf(String.valueOf(retval)).concat(String.valueOf(String.valueOf(TokenMgrError.addEscapes(tok.image))));
            tok = tok.next;
        }
        return retval;
    }
}

