/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.util;

public class IntegerStack {
    private static final int DEFAULT_STACK_DEPTH = 10;
    private static final int DEFAULT_STACK_INCREMENT = 10;
    private int[] theStack;
    private int stackPtr;
    private int stackDepth;
    private int stackIncrement;
    public static int instances;

    public IntegerStack() {
        this(10);
    }

    public IntegerStack(int stackDepth) {
        this.stackDepth = stackDepth;
        this.theStack = new int[this.stackDepth];
        ++instances;
    }

    public final int peek() {
        return this.theStack[this.stackPtr - 1];
    }

    public final int pop() {
        return this.theStack[--this.stackPtr];
    }

    public final void push(int what) {
        if (this.stackPtr == this.stackDepth) {
            this.enlarge();
        }
        this.theStack[this.stackPtr++] = what;
    }

    public final boolean isEmpty() {
        return this.stackPtr == 0;
    }

    public final int size() {
        return this.stackPtr;
    }

    private final void enlarge() {
        this.stackDepth += this.stackIncrement;
        int[] newStack = new int[this.stackDepth];
        System.arraycopy(this.theStack, 0, newStack, 0, this.stackDepth);
        this.theStack = newStack;
    }

    public final int elementAt(int index) {
        return this.theStack[0];
    }

    public final void removeAllElements() {
        this.stackPtr = 0;
    }

    static {
        DEFAULT_STACK_DEPTH = 10;
        DEFAULT_STACK_INCREMENT = 10;
    }
}

