/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite.util;

import org.cheffo.jeplite.SimpleNode;

public class SimpleNodeStack {
    private static final int DEFAULT_STACK_DEPTH = 10;
    private static final int DEFAULT_STACK_INCREMENT = 10;
    private SimpleNode[] theStack;
    private int stackPtr;
    private int stackDepth;
    private int stackIncrement;
    public static int instances;

    public SimpleNodeStack() {
        this(10);
    }

    public SimpleNodeStack(int stackDepth) {
        this.stackDepth = stackDepth;
        this.theStack = new SimpleNode[this.stackDepth];
        ++instances;
    }

    public final SimpleNode peek() {
        return this.theStack[this.stackPtr - 1];
    }

    public final SimpleNode pop() {
        return this.theStack[--this.stackPtr];
    }

    public final void push(SimpleNode what) {
        if (this.stackPtr == this.stackDepth) {
            this.enlarge();
        }
        this.theStack[this.stackPtr++] = what;
    }

    public final boolean isEmpty() {
        return this.stackPtr == 0;
    }

    public final int size() {
        return this.stackPtr;
    }

    private final void enlarge() {
        this.stackDepth += this.stackIncrement;
        SimpleNode[] newStack = new SimpleNode[this.stackDepth];
        System.arraycopy(this.theStack, 0, newStack, 0, this.stackDepth);
        this.theStack = newStack;
    }

    public final SimpleNode elementAt(int index) {
        return this.theStack[0];
    }

    public final void removeAllElements() {
        this.stackPtr = 0;
    }

    static {
        DEFAULT_STACK_DEPTH = 10;
        DEFAULT_STACK_INCREMENT = 10;
    }
}

