/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.chocosolver.sat.SatFactory;

public class SatSolver
implements SatFactory {
    static final int kUndefinedLiteral = -2;
    boolean ok_ = true;
    ArrayList<Clause> clauses = new ArrayList();
    ArrayList<Clause> learnts = new ArrayList();
    TIntObjectHashMap<ArrayList<Watcher>> watches_ = new TIntObjectHashMap();
    TIntObjectHashMap<TIntArrayList> implies_ = new TIntObjectHashMap();
    TIntObjectHashMap<Boolean> assignment_ = new TIntObjectHashMap();
    TIntArrayList trail_ = new TIntArrayList();
    TIntArrayList trail_markers_ = new TIntArrayList();
    int qhead_ = 0;
    int num_vars_ = 0;
    TIntArrayList temporary_add_vector_ = new TIntArrayList();
    TIntArrayList touched_variables_ = new TIntArrayList();

    @Override
    public SatSolver _me() {
        return this;
    }

    public int newVariable() {
        int v = this.incrementVariableCounter();
        this.assignment_.put(v, (Object)Boolean.kUndefined);
        return v;
    }

    boolean addClause(TIntList ps) {
        assert (0 == this.trailMarker());
        if (!this.ok_) {
            return false;
        }
        ps.sort();
        int lit = -2;
        int j = 0;
        for (int i = 0; i < ps.size(); ++i) {
            if (this.valueLit(ps.get(i)) == Boolean.kTrue || ps.get(i) == SatSolver.negated(lit)) {
                return true;
            }
            if (this.valueLit(ps.get(i)) == Boolean.kFalse || ps.get(i) == lit) continue;
            lit = ps.get(i);
            ps.set(j++, lit);
        }
        if (j < ps.size()) {
            ps.remove(j, ps.size() - j);
        }
        switch (ps.size()) {
            case 0: {
                this.ok_ = false;
                return false;
            }
            case 1: {
                this.uncheckedEnqueue(ps.get(0));
                this.ok_ = this.propagate();
                return this.ok_;
            }
            case 2: {
                int l0 = ps.get(0);
                int l1 = ps.get(1);
                TIntArrayList i0 = (TIntArrayList)this.implies_.get(SatSolver.negated(l0));
                if (i0 == null) {
                    i0 = new TIntArrayList();
                    this.implies_.put(SatSolver.negated(l0), (Object)i0);
                }
                i0.add(l1);
                TIntArrayList i1 = (TIntArrayList)this.implies_.get(SatSolver.negated(l1));
                if (i1 == null) {
                    i1 = new TIntArrayList();
                    this.implies_.put(SatSolver.negated(l1), (Object)i1);
                }
                i1.add(l0);
                break;
            }
            default: {
                Clause cr = new Clause(ps.toArray());
                this.clauses.add(cr);
                this.attachClause(cr);
            }
        }
        return true;
    }

    public boolean learnClause(int ... ps) {
        Arrays.sort(ps);
        switch (ps.length) {
            case 0: {
                this.ok_ = false;
                return false;
            }
            case 1: {
                this.dynUncheckedEnqueue(ps[0]);
                this.ok_ = this.propagate();
                return this.ok_;
            }
        }
        Clause cr = new Clause(ps);
        this.learnts.add(cr);
        this.attachClause(cr);
        return true;
    }

    boolean addEmptyClause() {
        this.temporary_add_vector_.resetQuick();
        return this.addClause((TIntList)this.temporary_add_vector_);
    }

    boolean addClause(int l) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(l);
        return this.addClause((TIntList)this.temporary_add_vector_);
    }

    boolean addClause(int p, int q) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        return this.addClause((TIntList)this.temporary_add_vector_);
    }

    boolean addClause(int p, int q, int r) {
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.add(p);
        this.temporary_add_vector_.add(q);
        this.temporary_add_vector_.add(r);
        return this.addClause((TIntList)this.temporary_add_vector_);
    }

    boolean initPropagator() {
        this.touched_variables_.resetQuick();
        return !this.ok_;
    }

    void cancelUntil(int level) {
        if (this.trailMarker() > level) {
            for (int c = this.trail_.size() - 1; c >= this.trail_markers_.get(level); --c) {
                int x = SatSolver.var(this.trail_.get(c));
                this.assignment_.put(x, (Object)Boolean.kUndefined);
            }
            this.qhead_ = this.trail_markers_.get(level);
            this.trail_.remove(this.trail_markers_.get(level), this.trail_.size() - this.trail_markers_.get(level));
            this.trail_markers_.remove(level, this.trail_markers_.size() - level);
        }
    }

    public int trailMarker() {
        return this.trail_markers_.size();
    }

    Boolean valueVar(int x) {
        return (Boolean)((Object)this.assignment_.get(x));
    }

    Boolean valueLit(int l) {
        Boolean b = (Boolean)((Object)this.assignment_.get(SatSolver.var(l)));
        return b == Boolean.kUndefined ? Boolean.kUndefined : SatSolver.xor(b, SatSolver.sign(l));
    }

    int nClauses() {
        return this.clauses.size();
    }

    int nLearnt() {
        return this.learnts.size();
    }

    boolean propagateOneLiteral(int lit) {
        assert (this.ok_);
        this.touched_variables_.resetQuick();
        if (!this.propagate()) {
            return false;
        }
        if (this.valueLit(lit) == Boolean.kTrue) {
            this.pushTrailMarker();
            return true;
        }
        if (this.valueLit(lit) == Boolean.kFalse) {
            return false;
        }
        this.pushTrailMarker();
        assert (this.valueLit(lit) == Boolean.kUndefined);
        this.assignment_.put(SatSolver.var(lit), (Object)SatSolver.makeBoolean(!SatSolver.sign(lit)));
        this.trail_.add(lit);
        return this.propagate();
    }

    private int incrementVariableCounter() {
        return this.num_vars_++;
    }

    void pushTrailMarker() {
        this.trail_markers_.add(this.trail_.size());
    }

    void uncheckedEnqueue(int l) {
        assert (this.valueLit(l) == Boolean.kUndefined);
        if (this.assignment_.get(SatSolver.var(l)) == Boolean.kUndefined) {
            this.touched_variables_.add(l);
        }
        this.assignment_.put(SatSolver.var(l), (Object)(SatSolver.sign(l) ? Boolean.kFalse : Boolean.kTrue));
        this.trail_.add(l);
    }

    void dynUncheckedEnqueue(int l) {
        this.touched_variables_.add(l);
    }

    boolean enqueue(int l) {
        if (this.valueLit(l) != Boolean.kUndefined) {
            return this.valueLit(l) != Boolean.kFalse;
        }
        this.uncheckedEnqueue(l);
        return true;
    }

    void attachClause(Clause cr) {
        ArrayList<Watcher> l1;
        assert (cr.size() > 1);
        ArrayList<Watcher> l0 = (ArrayList<Watcher>)this.watches_.get(SatSolver.negated(cr._g(0)));
        if (l0 == null) {
            l0 = new ArrayList<Watcher>();
            this.watches_.put(SatSolver.negated(cr._g(0)), l0);
        }
        if ((l1 = (ArrayList<Watcher>)this.watches_.get(SatSolver.negated(cr._g(1)))) == null) {
            l1 = new ArrayList<Watcher>();
            this.watches_.put(SatSolver.negated(cr._g(1)), l1);
        }
        l0.add(new Watcher(cr, cr._g(1)));
        l1.add(new Watcher(cr, cr._g(0)));
    }

    public void detachLearnt(int ci) {
        int i;
        Clause cr = this.learnts.get(ci);
        this.learnts.remove(ci);
        ArrayList ws = (ArrayList)this.watches_.get(SatSolver.negated(cr._g(0)));
        for (i = ws.size() - 1; i >= 0 && ((Watcher)ws.get((int)i)).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
        ws = (ArrayList)this.watches_.get(SatSolver.negated(cr._g(1)));
        for (i = ws.size() - 1; i >= 0 && ((Watcher)ws.get((int)i)).clause != cr; --i) {
        }
        assert (i > -1);
        ws.remove(i);
    }

    boolean propagate() {
        boolean result = true;
        while (this.qhead_ < this.trail_.size()) {
            int p;
            if (!this.propagateImplies(p = this.trail_.get(this.qhead_++))) {
                return false;
            }
            result &= this.propagateClauses(p);
        }
        return result;
    }

    private boolean propagateClauses(int p) {
        boolean result = true;
        ArrayList ws = (ArrayList)this.watches_.get(p);
        int i = 0;
        int j = 0;
        while (ws != null && i < ws.size()) {
            int blocker = ((Watcher)ws.get((int)i)).blocker;
            if (this.valueLit(blocker) == Boolean.kTrue) {
                ws.set(j++, ws.get(i++));
                continue;
            }
            Clause cr = ((Watcher)ws.get((int)i)).clause;
            int false_lit = SatSolver.negated(p);
            if (cr._g(0) == false_lit) {
                cr._s(0, cr._g(1));
                cr._s(1, false_lit);
            }
            assert (cr._g(1) == false_lit);
            ++i;
            int first = cr._g(0);
            Watcher w = new Watcher(cr, first);
            if (first != blocker && this.valueLit(first) == Boolean.kTrue) {
                ws.set(j++, w);
                continue;
            }
            boolean cont = false;
            for (int k = 2; k < cr.size(); ++k) {
                if (this.valueLit(cr._g(k)) == Boolean.kFalse) continue;
                cr._s(1, cr._g(k));
                cr._s(k, false_lit);
                ArrayList<Watcher> lw = (ArrayList<Watcher>)this.watches_.get(SatSolver.negated(cr._g(1)));
                if (lw == null) {
                    lw = new ArrayList<Watcher>();
                    this.watches_.put(SatSolver.negated(cr._g(1)), lw);
                }
                lw.add(w);
                cont = true;
                break;
            }
            if (cont) continue;
            ws.set(j++, w);
            if (this.valueLit(first) == Boolean.kFalse) {
                result = false;
                this.qhead_ = this.trail_.size();
                while (i < ws.size()) {
                    ws.set(j++, ws.get(i++));
                }
                this.touched_variables_.add(first);
                continue;
            }
            this.uncheckedEnqueue(first);
        }
        if (ws != null) {
            for (int k = ws.size() - 1; k >= j; --k) {
                ws.remove(k);
            }
        }
        return result;
    }

    private boolean propagateImplies(int p) {
        TIntList to_add = (TIntList)this.implies_.get(p);
        if (to_add != null) {
            for (int i = 0; i < to_add.size(); ++i) {
                if (this.enqueue(to_add.get(i))) continue;
                this.touched_variables_.add(to_add.get(i));
                return false;
            }
        }
        return true;
    }

    protected static int makeLiteral(int var, boolean sign) {
        return 2 * var + (sign ? 1 : 0);
    }

    public static int negated(int l) {
        return l ^ 1;
    }

    protected static boolean sign(int l) {
        return (l & 1) != 0;
    }

    protected static int var(int l) {
        return l >> 1;
    }

    protected static Boolean makeBoolean(boolean b) {
        return b ? Boolean.kTrue : Boolean.kFalse;
    }

    protected static Boolean xor(Boolean a, boolean b) {
        return Boolean.make((byte)(a.value() ^ (b ? (byte)1 : 0)));
    }

    public void copyFrom(SatSolver o) {
        this.ok_ = o.ok_;
        this.qhead_ = o.qhead_;
        this.num_vars_ = o.num_vars_;
        this.trail_.resetQuick();
        this.trail_.addAll((TIntCollection)o.trail_);
        this.trail_markers_.resetQuick();
        this.trail_markers_.addAll((TIntCollection)o.trail_markers_);
        this.touched_variables_.resetQuick();
        this.touched_variables_.addAll((TIntCollection)o.touched_variables_);
        this.temporary_add_vector_.resetQuick();
        this.temporary_add_vector_.addAll((TIntCollection)o.temporary_add_vector_);
        for (int k : o.assignment_.keys()) {
            this.assignment_.putIfAbsent(k, o.assignment_.get(k));
        }
        for (int k : o.implies_.keys()) {
            TIntArrayList tl = (TIntArrayList)this.implies_.get(k);
            if (tl == null) {
                tl = new TIntArrayList();
                this.implies_.put(k, (Object)tl);
            } else {
                tl.resetQuick();
            }
            tl.addAll((TIntCollection)o.implies_.get(k));
        }
        HashMap<Clause, Clause> map = new HashMap<Clause, Clause>();
        this.clauses.clear();
        for (Clause cl : o.clauses) {
            Clause _cl = new Clause(cl.literals_);
            map.put(cl, _cl);
            this.clauses.add(_cl);
        }
        this.learnts.clear();
        for (Clause cl : o.learnts) {
            Clause _cl = new Clause(cl.literals_);
            map.put(cl, _cl);
            this.learnts.add(_cl);
        }
        this.watches_.clear();
        for (Object k : (Object)o.watches_.keys()) {
            ArrayList ws = (ArrayList)o.watches_.get((int)k);
            ArrayList<Watcher> _ws = new ArrayList<Watcher>(ws.size());
            for (Watcher w : ws) {
                _ws.add(new Watcher((Clause)map.get(w.clause), w.blocker));
            }
            this.watches_.put((int)k, _ws);
        }
    }

    public long nbclauses() {
        return this.clauses.size() + this.learnts.size() + this.implies_.size() / 2;
    }

    public long numvars() {
        return this.num_vars_;
    }

    static enum Boolean {
        kTrue(0),
        kFalse(1),
        kUndefined(2);

        byte value;

        private Boolean(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Boolean make(byte b) {
            if (b == 0) {
                return kTrue;
            }
            if (b == 1) {
                return kFalse;
            }
            return kUndefined;
        }
    }

    class Watcher {
        Clause clause;
        int blocker;

        public Watcher(Clause cr, int l) {
            this.clause = cr;
            this.blocker = l;
        }
    }

    class Clause {
        private int[] literals_;

        public Clause(int[] ps) {
            this.literals_ = (int[])ps.clone();
        }

        int size() {
            return this.literals_.length;
        }

        int _g(int i) {
            return this.literals_[i];
        }

        int _s(int pos, int l) {
            this.literals_[pos] = l;
            return this.literals_[pos];
        }

        int pos(int l) {
            int i;
            for (i = this.literals_.length - 1; i >= 0 && this.literals_[i] != l; --i) {
            }
            return i;
        }

        public String toString() {
            return Arrays.toString(this.literals_);
        }
    }
}

