/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.connect.plugin.impl;

import java.util.concurrent.Callable;
import org.cibseven.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.cibseven.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.cibseven.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.cibseven.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.cibseven.connect.ConnectorException;
import org.cibseven.connect.Connectors;
import org.cibseven.connect.plugin.impl.ConnectorVariableScope;
import org.cibseven.connect.spi.Connector;
import org.cibseven.connect.spi.ConnectorRequest;
import org.cibseven.connect.spi.ConnectorResponse;

public class ServiceTaskConnectorActivityBehavior
extends TaskActivityBehavior {
    protected String connectorId;
    protected Connector<?> connectorInstance;
    protected IoMapping ioMapping;

    public ServiceTaskConnectorActivityBehavior(String connectorId, IoMapping ioMapping) {
        this.connectorId = connectorId;
        this.ioMapping = ioMapping;
    }

    public void execute(final ActivityExecution execution) throws Exception {
        this.ensureConnectorInitialized();
        this.executeWithErrorPropagation(execution, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ConnectorRequest request = ServiceTaskConnectorActivityBehavior.this.connectorInstance.createRequest();
                ServiceTaskConnectorActivityBehavior.this.applyInputParameters(execution, request);
                ConnectorResponse response = request.execute();
                ServiceTaskConnectorActivityBehavior.this.applyOutputParameters(execution, response);
                ServiceTaskConnectorActivityBehavior.this.leave(execution);
                return null;
            }
        });
    }

    protected void applyInputParameters(ActivityExecution execution, ConnectorRequest<?> request) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorInputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            this.ioMapping.executeInputParameters((AbstractVariableScope)connectorInputVariableScope);
            connectorInputVariableScope.writeToRequest(request);
        }
    }

    protected void applyOutputParameters(ActivityExecution execution, ConnectorResponse response) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorOutputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            connectorOutputVariableScope.readFromResponse(response);
            this.ioMapping.executeOutputParameters((AbstractVariableScope)connectorOutputVariableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConnectorInitialized() {
        if (this.connectorInstance == null) {
            ServiceTaskConnectorActivityBehavior serviceTaskConnectorActivityBehavior = this;
            synchronized (serviceTaskConnectorActivityBehavior) {
                if (this.connectorInstance == null) {
                    this.connectorInstance = Connectors.getConnector((String)this.connectorId);
                    if (this.connectorInstance == null) {
                        throw new ConnectorException("No connector found for connector id '" + this.connectorId + "'");
                    }
                }
            }
        }
    }
}

