/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cibseven.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.cibseven.spin.DataFormats;
import org.cibseven.spin.json.SpinJsonNode;
import org.cibseven.spin.plugin.impl.JsonValueSerializer;
import org.cibseven.spin.plugin.impl.SpinObjectValueSerializer;
import org.cibseven.spin.plugin.impl.XmlValueSerializer;
import org.cibseven.spin.spi.DataFormat;
import org.cibseven.spin.xml.SpinXmlElement;

public class SpinVariableSerializers {
    public static List<TypedValueSerializer<?>> createObjectValueSerializers(DataFormats dataFormats) {
        ArrayList serializers = new ArrayList();
        Set availableDataFormats = dataFormats.getAllAvailableDataFormats();
        for (DataFormat dataFormat : availableDataFormats) {
            serializers.add((TypedValueSerializer<?>)new SpinObjectValueSerializer("spin://" + dataFormat.getName(), dataFormat));
        }
        return serializers;
    }

    public static List<TypedValueSerializer<?>> createSpinValueSerializers(DataFormats dataFormats) {
        ArrayList serializers = new ArrayList();
        if (dataFormats.getDataFormatByName(DataFormats.JSON_DATAFORMAT_NAME) != null) {
            DataFormat jsonDataFormat = dataFormats.getDataFormatByName(DataFormats.JSON_DATAFORMAT_NAME);
            serializers.add((TypedValueSerializer<?>)new JsonValueSerializer((DataFormat<SpinJsonNode>)jsonDataFormat));
        }
        if (dataFormats.getDataFormatByName(DataFormats.XML_DATAFORMAT_NAME) != null) {
            DataFormat xmlDataFormat = dataFormats.getDataFormatByName(DataFormats.XML_DATAFORMAT_NAME);
            serializers.add((TypedValueSerializer<?>)new XmlValueSerializer((DataFormat<SpinXmlElement>)xmlDataFormat));
        }
        return serializers;
    }
}

