/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.plugin.impl;

import java.util.List;
import org.cibseven.bpm.application.AbstractProcessApplication;
import org.cibseven.bpm.application.ProcessApplicationInterface;
import org.cibseven.bpm.container.impl.plugin.BpmPlatformPlugin;
import org.cibseven.bpm.engine.impl.variable.serializer.DefaultVariableSerializers;
import org.cibseven.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.cibseven.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.cibseven.spin.DataFormats;
import org.cibseven.spin.plugin.impl.SpinPluginLogger;
import org.cibseven.spin.plugin.impl.SpinVariableSerializers;

public class SpinBpmPlatformPlugin
implements BpmPlatformPlugin {
    private static final SpinPluginLogger LOG = SpinPluginLogger.LOGGER;

    public void postProcessApplicationDeploy(ProcessApplicationInterface processApplication) {
        ProcessApplicationInterface rawPa = processApplication.getRawObject();
        if (rawPa instanceof AbstractProcessApplication) {
            this.initializeVariableSerializers((AbstractProcessApplication)rawPa);
        } else {
            LOG.logNoDataFormatsInitiailized("process application data formats", "process application is not a sub class of " + AbstractProcessApplication.class.getName());
        }
    }

    protected void initializeVariableSerializers(AbstractProcessApplication abstractProcessApplication) {
        VariableSerializers paVariableSerializers = abstractProcessApplication.getVariableSerializers();
        if (paVariableSerializers == null) {
            paVariableSerializers = new DefaultVariableSerializers();
            abstractProcessApplication.setVariableSerializers(paVariableSerializers);
        }
        for (TypedValueSerializer<?> serializer : this.lookupSpinSerializers(abstractProcessApplication.getProcessApplicationClassloader())) {
            paVariableSerializers.addSerializer(serializer);
        }
    }

    protected List<TypedValueSerializer<?>> lookupSpinSerializers(ClassLoader classLoader) {
        DataFormats paDataFormats = new DataFormats();
        paDataFormats.registerDataFormats(classLoader);
        return SpinVariableSerializers.createObjectValueSerializers(paDataFormats);
    }

    public void postProcessApplicationUndeploy(ProcessApplicationInterface processApplication) {
    }
}

