/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.plugin.impl.feel.integration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.valuemapper.JavaCustomValueMapper;
import org.cibseven.spin.json.SpinJsonNode;
import org.cibseven.spin.xml.SpinXmlAttribute;
import org.cibseven.spin.xml.SpinXmlElement;
import org.cibseven.spin.xml.SpinXmlNode;

public class SpinValueMapper
extends JavaCustomValueMapper {
    public Optional<Val> toValue(Object x, Function<Object, Val> innerValueMapper) {
        if (x instanceof SpinJsonNode) {
            SpinJsonNode node = (SpinJsonNode)x;
            return Optional.of(this.spinJsonToVal(node, innerValueMapper));
        }
        if (x instanceof SpinXmlElement) {
            SpinXmlElement element = (SpinXmlElement)x;
            return Optional.of(this.spinXmlToVal(element, innerValueMapper));
        }
        return Optional.empty();
    }

    public Optional<Object> unpackValue(Val value, Function<Val, Object> innerValueMapper) {
        return Optional.empty();
    }

    public int priority() {
        return 30;
    }

    protected Val spinJsonToVal(SpinJsonNode node, Function<Object, Val> innerValueMapper) {
        if (node.isObject()) {
            Map<String, Val> pairs = node.fieldNames().stream().collect(Collectors.toMap(field -> field, field -> this.spinJsonToVal(node.prop(field), innerValueMapper)));
            return innerValueMapper.apply(pairs);
        }
        if (node.isArray().booleanValue()) {
            List values = node.elements().stream().map(e -> this.spinJsonToVal((SpinJsonNode)e, innerValueMapper)).collect(Collectors.toList());
            return innerValueMapper.apply(values);
        }
        if (node.isNull().booleanValue()) {
            return innerValueMapper.apply(null);
        }
        return innerValueMapper.apply(node.value());
    }

    protected Val spinXmlToVal(SpinXmlElement element, Function<Object, Val> innerValueMapper) {
        String name = this.nodeName((SpinXmlNode)element);
        Val value = this.spinXmlElementToVal(element, innerValueMapper);
        Map<String, Val> map = Collections.singletonMap(name, value);
        return innerValueMapper.apply(map);
    }

    protected Val spinXmlElementToVal(SpinXmlElement e, Function<Object, Val> innerValueMapper) {
        Map<String, ValString> attributes;
        HashMap<String, Object> membersMap = new HashMap<String, Object>();
        String content = e.textContent().trim();
        if (!content.isEmpty()) {
            membersMap.put("$content", new ValString(content));
        }
        if (!(attributes = e.attrs().stream().collect(Collectors.toMap(this::spinXmlAttributeToKey, attr -> new ValString(attr.value())))).isEmpty()) {
            membersMap.putAll(attributes);
        }
        Map<String, Val> childrenMap = e.childElements().stream().collect(Collectors.groupingBy(this::nodeName, Collectors.mapping(el -> this.spinXmlElementToVal((SpinXmlElement)el, innerValueMapper), Collectors.toList()))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List valList = (List)entry.getValue();
            if (!valList.isEmpty() && valList.size() > 1) {
                return (Val)innerValueMapper.apply(valList);
            }
            return (Val)valList.get(0);
        }));
        membersMap.putAll(childrenMap);
        if (membersMap.isEmpty()) {
            return innerValueMapper.apply(null);
        }
        return innerValueMapper.apply(membersMap);
    }

    protected String spinXmlAttributeToKey(SpinXmlAttribute attribute) {
        return "@" + this.nodeName((SpinXmlNode)attribute);
    }

    protected String nodeName(SpinXmlNode n) {
        String prefix = n.prefix();
        String name = n.name();
        return prefix != null && !prefix.isEmpty() ? prefix + "$" + name : name;
    }
}

