/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.RepositoryService;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.cibseven.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.CommandCounterInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.CommandInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.LogInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.cibseven.bpm.engine.repository.DeploymentBuilder;
import org.cibseven.bpm.engine.spring.SpringTransactionContextFactory;
import org.cibseven.bpm.engine.spring.SpringTransactionInterceptor;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringTransactionsProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentTenantId;
    protected boolean deployChangedOnly;

    public SpringTransactionsProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
    }

    public ProcessEngine buildProcessEngine() {
        ProcessEngine processEngine = super.buildProcessEngine();
        this.autoDeployResources(processEngine);
        return processEngine;
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        if (this.transactionManager == null) {
            throw new ProcessEngineException("transactionManager is required property for SpringProcessEngineConfiguration, use " + StandaloneProcessEngineConfiguration.class.getName() + " otherwise");
        }
        ArrayList<Object> defaultCommandInterceptorsTxRequired = new ArrayList<Object>();
        if (!this.isDisableExceptionCode()) {
            defaultCommandInterceptorsTxRequired.add(this.getExceptionCodeInterceptor());
        }
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new CommandCounterInterceptor((ProcessEngineConfigurationImpl)this));
        defaultCommandInterceptorsTxRequired.add(new ProcessApplicationContextInterceptor((ProcessEngineConfigurationImpl)this));
        defaultCommandInterceptorsTxRequired.add((Object)new SpringTransactionInterceptor(this.transactionManager, 0, this));
        CommandContextInterceptor commandContextInterceptor = new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this);
        defaultCommandInterceptorsTxRequired.add(commandContextInterceptor);
        return defaultCommandInterceptorsTxRequired;
    }

    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<Object> defaultCommandInterceptorsTxRequiresNew = new ArrayList<Object>();
        if (!this.isDisableExceptionCode()) {
            defaultCommandInterceptorsTxRequiresNew.add(this.getExceptionCodeInterceptor());
        }
        defaultCommandInterceptorsTxRequiresNew.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequiresNew.add(new CommandCounterInterceptor((ProcessEngineConfigurationImpl)this));
        defaultCommandInterceptorsTxRequiresNew.add(new ProcessApplicationContextInterceptor((ProcessEngineConfigurationImpl)this));
        defaultCommandInterceptorsTxRequiresNew.add((Object)new SpringTransactionInterceptor(this.transactionManager, 3, this));
        CommandContextInterceptor commandContextInterceptor = new CommandContextInterceptor(this.commandContextFactory, (ProcessEngineConfigurationImpl)this, true);
        defaultCommandInterceptorsTxRequiresNew.add(commandContextInterceptor);
        return defaultCommandInterceptorsTxRequiresNew;
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager);
        }
    }

    protected void autoDeployResources(ProcessEngine processEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            RepositoryService repositoryService = processEngine.getRepositoryService();
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering(this.deployChangedOnly).name(this.deploymentName).tenantId(this.deploymentTenantId);
            for (Resource resource : this.deploymentResources) {
                String resourceName = null;
                resourceName = resource instanceof ContextResource ? ((ContextResource)resource).getPathWithinContext() : (resource instanceof ByteArrayResource ? resource.getDescription() : this.getFileResourceName(resource));
                try {
                    if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                        deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                        continue;
                    }
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
                catch (IOException e) {
                    throw new ProcessEngineException("couldn't auto deploy resource '" + String.valueOf(resource) + "': " + e.getMessage(), (Throwable)e);
                }
            }
            deploymentBuilder.deploy();
        }
    }

    protected String getFileResourceName(Resource resource) {
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException e) {
            return resource.getFilename();
        }
    }

    public ProcessEngineConfigurationImpl setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public String getDeploymentTenantId() {
        return this.deploymentTenantId;
    }

    public void setDeploymentTenantId(String deploymentTenantId) {
        this.deploymentTenantId = deploymentTenantId;
    }

    public boolean isDeployChangedOnly() {
        return this.deployChangedOnly;
    }

    public void setDeployChangedOnly(boolean deployChangedOnly) {
        this.deployChangedOnly = deployChangedOnly;
    }
}

