/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring.components.jobexecutor;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.cibseven.bpm.engine.impl.ProcessEngineImpl;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SpringJobExecutor
extends JobExecutor {
    private TaskExecutor taskExecutor;

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        try {
            this.taskExecutor.execute(this.getExecuteJobsRunnable(jobIds, processEngine));
        }
        catch (RejectedExecutionException e) {
            this.logRejectedExecution(processEngine, jobIds.size());
            this.rejectedJobsHandler.jobsRejected(jobIds, processEngine, (JobExecutor)this);
        }
        finally {
            if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
                this.logJobExecutionInfo(processEngine, ((ThreadPoolTaskExecutor)this.taskExecutor).getQueueSize(), ((ThreadPoolTaskExecutor)this.taskExecutor).getQueueCapacity(), ((ThreadPoolTaskExecutor)this.taskExecutor).getMaxPoolSize(), ((ThreadPoolTaskExecutor)this.taskExecutor).getActiveCount());
            }
        }
    }

    protected void startExecutingJobs() {
        this.startJobAcquisitionThread();
    }

    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
    }
}

