/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.container.impl.deployment.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.cibseven.bpm.container.impl.ContainerIntegrationLogger;
import org.cibseven.bpm.container.impl.deployment.scanning.ProcessApplicationScanningUtil;
import org.cibseven.bpm.container.impl.deployment.scanning.spi.ProcessApplicationScanner;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.util.IoUtil;

public class ClassPathProcessApplicationScanner
implements ProcessApplicationScanner {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl) {
        return this.findResources(classLoader, paResourceRootPath, metaFileUrl, null);
    }

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl, String[] additionalResourceSuffixes) {
        HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
        this.scanPaResourceRootPath(classLoader, metaFileUrl, paResourceRootPath, additionalResourceSuffixes, resourceMap);
        return resourceMap;
    }

    public void scanPaResourceRootPath(ClassLoader classLoader, URL metaFileUrl, String paResourceRootPath, Map<String, byte[]> resourceMap) {
        this.scanPaResourceRootPath(classLoader, metaFileUrl, paResourceRootPath, null, resourceMap);
    }

    public void scanPaResourceRootPath(ClassLoader classLoader, URL metaFileUrl, String paResourceRootPath, String[] additionalResourceSuffixes, Map<String, byte[]> resourceMap) {
        if (paResourceRootPath != null && !paResourceRootPath.startsWith("pa:")) {
            Object strippedPath = paResourceRootPath.replace("classpath:", "");
            strippedPath = ((String)strippedPath).endsWith("/") ? strippedPath : (String)strippedPath + "/";
            Enumeration<URL> resourceRoots = this.loadClasspathResourceRoots(classLoader, (String)strippedPath);
            while (resourceRoots.hasMoreElements()) {
                URL resourceRoot = resourceRoots.nextElement();
                this.scanUrl(resourceRoot, (String)strippedPath, false, additionalResourceSuffixes, resourceMap);
            }
        } else {
            Object strippedPaResourceRootPath = null;
            if (paResourceRootPath != null) {
                strippedPaResourceRootPath = paResourceRootPath.replace("pa:", "");
                strippedPaResourceRootPath = ((String)strippedPaResourceRootPath).endsWith("/") ? strippedPaResourceRootPath : (String)strippedPaResourceRootPath + "/";
            }
            this.scanUrl(metaFileUrl, (String)strippedPaResourceRootPath, true, additionalResourceSuffixes, resourceMap);
        }
    }

    protected void scanUrl(URL url, String paResourceRootPath, boolean isPaLocal, String[] additionalResourceSuffixes, Map<String, byte[]> resourceMap) {
        int withinArchive;
        String urlPath = url.toExternalForm();
        if (isPaLocal) {
            if (urlPath.startsWith("file:") || urlPath.startsWith("jar:") || urlPath.startsWith("wsjar:") || urlPath.startsWith("zip:")) {
                urlPath = url.getPath();
                withinArchive = urlPath.indexOf(33);
                if (withinArchive != -1) {
                    urlPath = urlPath.substring(0, withinArchive);
                } else {
                    File file = new File(urlPath);
                    urlPath = file.getParentFile().getParent();
                }
            }
        } else if ((urlPath.startsWith("file:") || urlPath.startsWith("jar:") || urlPath.startsWith("wsjar:") || urlPath.startsWith("zip:")) && (withinArchive = (urlPath = url.getPath()).indexOf(33)) != -1) {
            urlPath = urlPath.substring(0, withinArchive);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw LOG.cannotDecodePathName(e);
        }
        LOG.debugRootPath(urlPath);
        this.scanPath(urlPath, paResourceRootPath, isPaLocal, additionalResourceSuffixes, resourceMap);
    }

    protected void scanPath(String urlPath, String paResourceRootPath, boolean isPaLocal, String[] additionalResourceSuffixes, Map<String, byte[]> resourceMap) {
        File file;
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.indexOf(33));
        }
        if ((file = new File(urlPath)).isDirectory()) {
            String path = file.getPath();
            String rootPath = path.endsWith(File.separator) ? path : path + File.separator;
            this.handleDirectory(file, rootPath, paResourceRootPath, paResourceRootPath, isPaLocal, additionalResourceSuffixes, resourceMap);
        } else {
            this.handleArchive(file, paResourceRootPath, additionalResourceSuffixes, resourceMap);
        }
    }

    protected void handleArchive(File file, String paResourceRootPath, String[] additionalResourceSuffixes, Map<String, byte[]> resourceMap) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String modelFileName = zipEntry.getName();
                if (!ProcessApplicationScanningUtil.isDeployable(modelFileName, additionalResourceSuffixes) || !this.isBelowPath(modelFileName, paResourceRootPath)) continue;
                String resourceName = modelFileName;
                if (paResourceRootPath != null && paResourceRootPath.length() > 0) {
                    resourceName = modelFileName.replaceFirst(paResourceRootPath, "");
                }
                this.addResource(zipFile.getInputStream(zipEntry), resourceMap, file.getName() + "!", resourceName);
                Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
                while (entries2.hasMoreElements()) {
                    ZipEntry zipEntry2 = entries2.nextElement();
                    String diagramFileName = zipEntry2.getName();
                    if (!ProcessApplicationScanningUtil.isDiagram(diagramFileName, modelFileName)) continue;
                    if (paResourceRootPath != null && paResourceRootPath.length() > 0) {
                        diagramFileName = diagramFileName.replaceFirst(paResourceRootPath, "");
                    }
                    this.addResource(zipFile.getInputStream(zipEntry), resourceMap, file.getName() + "!", diagramFileName);
                }
            }
            zipFile.close();
        }
        catch (IOException e) {
            throw LOG.exceptionWhileScanning(file.getAbsolutePath(), e);
        }
    }

    protected void handleDirectory(File directory, String rootPath, String localPath, String paResourceRootPath, boolean isPaLocal, String[] additionalResourceSuffixes, Map<String, byte[]> resourceMap) {
        File[] paths = directory.listFiles();
        String currentPathSegment = localPath;
        if (localPath != null && localPath.length() > 0) {
            if (localPath.indexOf(47) > 0) {
                currentPathSegment = localPath.substring(0, localPath.indexOf(47));
                localPath = localPath.substring(localPath.indexOf(47) + 1, localPath.length());
            } else {
                localPath = null;
            }
        }
        for (File path : paths) {
            if (isPaLocal && currentPathSegment != null && currentPathSegment.length() > 0) {
                if (!path.isDirectory() || !path.getName().equals(currentPathSegment)) continue;
                this.handleDirectory(path, rootPath, localPath, paResourceRootPath, isPaLocal, additionalResourceSuffixes, resourceMap);
                continue;
            }
            String modelFileName = path.getPath();
            if (!path.isDirectory() && ProcessApplicationScanningUtil.isDeployable(modelFileName, additionalResourceSuffixes)) {
                this.addResource(path, resourceMap, paResourceRootPath, modelFileName.replace(rootPath, "").replace("\\", "/"));
                for (File file : paths) {
                    String diagramFileName = file.getPath();
                    if (path.isDirectory() || !ProcessApplicationScanningUtil.isDiagram(diagramFileName, modelFileName)) continue;
                    this.addResource(file, resourceMap, paResourceRootPath, diagramFileName.replace(rootPath, "").replace("\\", "/"));
                }
                continue;
            }
            if (!path.isDirectory()) continue;
            this.handleDirectory(path, rootPath, localPath, paResourceRootPath, isPaLocal, additionalResourceSuffixes, resourceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResource(Object source, Map<String, byte[]> resourceMap, String resourceRootPath, String resourceName) {
        String resourcePath = (resourceRootPath == null ? "" : resourceRootPath).concat(resourceName);
        LOG.debugDiscoveredResource(resourcePath);
        InputStream inputStream = null;
        try {
            if (source instanceof File) {
                try {
                    inputStream = new FileInputStream((File)source);
                }
                catch (IOException e) {
                    throw LOG.cannotOpenFileInputStream(((File)source).getAbsolutePath(), e);
                }
            } else {
                inputStream = (InputStream)source;
            }
            byte[] bytes = IoUtil.readInputStream(inputStream, resourcePath);
            resourceMap.put(resourceName, bytes);
        }
        finally {
            if (inputStream != null) {
                IoUtil.closeSilently(inputStream);
            }
        }
    }

    protected Enumeration<URL> loadClasspathResourceRoots(ClassLoader classLoader, String strippedPaResourceRootPath) {
        Enumeration<URL> resourceRoots;
        try {
            resourceRoots = classLoader.getResources(strippedPaResourceRootPath);
        }
        catch (IOException e) {
            throw LOG.couldNotGetResource(strippedPaResourceRootPath, classLoader, e);
        }
        return resourceRoots;
    }

    protected boolean isBelowPath(String processFileName, String paResourceRootPath) {
        if (paResourceRootPath == null || paResourceRootPath.length() == 0) {
            return true;
        }
        return processFileName.startsWith(paResourceRootPath);
    }
}

