/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.container.impl.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.container.impl.ContainerIntegrationLogger;
import org.cibseven.bpm.container.impl.metadata.ProcessEnginePluginXmlImpl;
import org.cibseven.bpm.container.impl.metadata.ProcessEngineXmlImpl;
import org.cibseven.bpm.container.impl.metadata.PropertyHelper;
import org.cibseven.bpm.container.impl.metadata.spi.ProcessEnginePluginXml;
import org.cibseven.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.util.xml.Element;
import org.cibseven.bpm.engine.impl.util.xml.Parse;
import org.cibseven.bpm.engine.impl.util.xml.Parser;

public abstract class DeploymentMetadataParse
extends Parse {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    public DeploymentMetadataParse(Parser parser) {
        super(parser);
    }

    @Override
    public Parse execute() {
        super.execute();
        try {
            this.parseRootElement();
        }
        catch (Exception e) {
            throw LOG.unknownExceptionWhileParsingDeploymentDescriptor(e);
        }
        finally {
            if (this.hasWarnings()) {
                this.logWarnings();
            }
            if (this.hasErrors()) {
                this.throwExceptionForErrors();
            }
        }
        return this;
    }

    protected abstract void parseRootElement();

    protected void parseProcessEngine(Element element, List<ProcessEngineXml> parsedProcessEngines) {
        ProcessEngineXmlImpl processEngine = new ProcessEngineXmlImpl();
        processEngine.setName(element.attribute("name"));
        String defaultValue = element.attribute("default");
        if (defaultValue == null || defaultValue.isEmpty()) {
            processEngine.setDefault(false);
        } else {
            processEngine.setDefault(Boolean.parseBoolean(defaultValue));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<ProcessEnginePluginXml> plugins = new ArrayList<ProcessEnginePluginXml>();
        for (Element childElement : element.elements()) {
            if ("configuration".equals(childElement.getTagName())) {
                processEngine.setConfigurationClass(childElement.getText());
                continue;
            }
            if ("datasource".equals(childElement.getTagName())) {
                processEngine.setDatasource(childElement.getText());
                continue;
            }
            if ("job-acquisition".equals(childElement.getTagName())) {
                processEngine.setJobAcquisitionName(childElement.getText());
                continue;
            }
            if ("properties".equals(childElement.getTagName())) {
                this.parseProperties(childElement, properties);
                continue;
            }
            if (!"plugins".equals(childElement.getTagName())) continue;
            this.parseProcessEnginePlugins(childElement, plugins);
        }
        processEngine.setProperties(properties);
        processEngine.setPlugins(plugins);
        parsedProcessEngines.add(processEngine);
    }

    protected void parseProcessEnginePlugins(Element element, List<ProcessEnginePluginXml> plugins) {
        for (Element chidElement : element.elements()) {
            if (!"plugin".equals(chidElement.getTagName())) continue;
            this.parseProcessEnginePlugin(chidElement, plugins);
        }
    }

    protected void parseProcessEnginePlugin(Element element, List<ProcessEnginePluginXml> plugins) {
        ProcessEnginePluginXmlImpl plugin = new ProcessEnginePluginXmlImpl();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element childElement : element.elements()) {
            if ("class".equals(childElement.getTagName())) {
                plugin.setPluginClass(childElement.getText());
                continue;
            }
            if (!"properties".equals(childElement.getTagName())) continue;
            this.parseProperties(childElement, properties);
        }
        plugin.setProperties(properties);
        plugins.add(plugin);
    }

    protected void parseProperties(Element element, Map<String, String> properties) {
        for (Element childElement : element.elements()) {
            if (!"property".equals(childElement.getTagName())) continue;
            String resolved = PropertyHelper.resolveProperty(System.getProperties(), childElement.getText());
            properties.put(childElement.attribute("name"), resolved);
        }
    }
}

