/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.cmd.EvaluateStartConditionCmd;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.runtime.ConditionEvaluationBuilder;
import org.cibseven.bpm.engine.runtime.ProcessInstance;
import org.cibseven.bpm.engine.variable.VariableMap;
import org.cibseven.bpm.engine.variable.impl.VariableMapImpl;

public class ConditionEvaluationBuilderImpl
implements ConditionEvaluationBuilder {
    protected CommandExecutor commandExecutor;
    protected String businessKey;
    protected String processDefinitionId;
    protected VariableMap variables = new VariableMapImpl();
    protected String tenantId = null;
    protected boolean isTenantIdSet = false;

    public ConditionEvaluationBuilderImpl(CommandExecutor commandExecutor) {
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    protected <T> T execute(Command<T> command) {
        return this.commandExecutor.execute(command);
    }

    @Override
    public ConditionEvaluationBuilder processInstanceBusinessKey(String businessKey) {
        EnsureUtil.ensureNotNull("businessKey", (Object)businessKey);
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ConditionEvaluationBuilder processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ConditionEvaluationBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.variables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public ConditionEvaluationBuilder setVariables(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull("variables", variables);
        if (variables != null) {
            this.variables.putAll(variables);
        }
        return this;
    }

    @Override
    public ConditionEvaluationBuilder tenantId(String tenantId) {
        EnsureUtil.ensureNotNull("The tenant-id cannot be null. Use 'withoutTenantId()' if you want to evaluate conditional start event with a process definition which has no tenant-id.", "tenantId", (Object)tenantId);
        this.isTenantIdSet = true;
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ConditionEvaluationBuilder withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantId = null;
        return this;
    }

    @Override
    public List<ProcessInstance> evaluateStartConditions() {
        return this.execute(new EvaluateStartConditionCmd(this));
    }
}

