/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import java.util.List;
import org.cibseven.bpm.engine.FilterService;
import org.cibseven.bpm.engine.filter.Filter;
import org.cibseven.bpm.engine.filter.FilterQuery;
import org.cibseven.bpm.engine.impl.ServiceImpl;
import org.cibseven.bpm.engine.impl.cmd.CreateFilterCmd;
import org.cibseven.bpm.engine.impl.cmd.DeleteFilterCmd;
import org.cibseven.bpm.engine.impl.cmd.ExecuteFilterCountCmd;
import org.cibseven.bpm.engine.impl.cmd.ExecuteFilterListCmd;
import org.cibseven.bpm.engine.impl.cmd.ExecuteFilterListPageCmd;
import org.cibseven.bpm.engine.impl.cmd.ExecuteFilterSingleResultCmd;
import org.cibseven.bpm.engine.impl.cmd.GetFilterCmd;
import org.cibseven.bpm.engine.impl.cmd.SaveFilterCmd;
import org.cibseven.bpm.engine.impl.filter.FilterQueryImpl;
import org.cibseven.bpm.engine.query.Query;

public class FilterServiceImpl
extends ServiceImpl
implements FilterService {
    @Override
    public Filter newTaskFilter() {
        return this.commandExecutor.execute(new CreateFilterCmd("Task"));
    }

    @Override
    public Filter newTaskFilter(String filterName) {
        return this.newTaskFilter().setName(filterName);
    }

    @Override
    public FilterQuery createFilterQuery() {
        return new FilterQueryImpl(this.commandExecutor);
    }

    @Override
    public FilterQuery createTaskFilterQuery() {
        return new FilterQueryImpl(this.commandExecutor).filterResourceType("Task");
    }

    @Override
    public Filter saveFilter(Filter filter) {
        return this.commandExecutor.execute(new SaveFilterCmd(filter));
    }

    @Override
    public Filter getFilter(String filterId) {
        return this.commandExecutor.execute(new GetFilterCmd(filterId));
    }

    @Override
    public void deleteFilter(String filterId) {
        this.commandExecutor.execute(new DeleteFilterCmd(filterId));
    }

    @Override
    public <T> List<T> list(String filterId) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListCmd(filterId));
    }

    @Override
    public <T, Q extends Query<?, T>> List<T> list(String filterId, Q extendingQuery) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListCmd(filterId, extendingQuery));
    }

    @Override
    public <T> List<T> listPage(String filterId, int firstResult, int maxResults) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListPageCmd(filterId, firstResult, maxResults));
    }

    @Override
    public <T, Q extends Query<?, T>> List<T> listPage(String filterId, Q extendingQuery, int firstResult, int maxResults) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListPageCmd(filterId, extendingQuery, firstResult, maxResults));
    }

    @Override
    public <T> T singleResult(String filterId) {
        return (T)this.commandExecutor.execute(new ExecuteFilterSingleResultCmd(filterId));
    }

    @Override
    public <T, Q extends Query<?, T>> T singleResult(String filterId, Q extendingQuery) {
        return (T)this.commandExecutor.execute(new ExecuteFilterSingleResultCmd(filterId, extendingQuery));
    }

    @Override
    public Long count(String filterId) {
        return this.commandExecutor.execute(new ExecuteFilterCountCmd(filterId));
    }

    @Override
    public Long count(String filterId, Query<?, ?> extendingQuery) {
        return this.commandExecutor.execute(new ExecuteFilterCountCmd(filterId, extendingQuery));
    }
}

