/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.cibseven.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.cibseven.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;

public class SequentialMultiInstanceActivityBehavior
extends MultiInstanceActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        this.prepareScope(execution, nrOfInstances);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        ActivityImpl innerActivity = this.getInnerActivity(execution.getActivity());
        this.performInstance(execution, innerActivity, 0);
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
        int loopCounter = this.getLoopVariable(scopeExecution, "loopCounter") + 1;
        int nrOfInstances = this.getLoopVariable(scopeExecution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(scopeExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        if (loopCounter == nrOfInstances || this.completionConditionSatisfied(scopeExecution)) {
            this.leave(scopeExecution);
        } else {
            ActivityImpl innerActivity = this.getInnerActivity(scopeExecution.getActivity());
            this.performInstance(scopeExecution, innerActivity, loopCounter);
        }
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
    }

    protected void prepareScope(ActivityExecution scopeExecution, int totalNumberOfInstances) {
        this.setLoopVariable(scopeExecution, "nrOfInstances", totalNumberOfInstances);
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", 0);
    }

    @Override
    public List<ActivityExecution> initializeScope(ActivityExecution scopeExecution, int nrOfInstances) {
        if (nrOfInstances > 1) {
            LOG.unsupportedConcurrencyException(scopeExecution.toString(), this.getClass().getSimpleName());
        }
        ArrayList<ActivityExecution> executions = new ArrayList<ActivityExecution>();
        this.prepareScope(scopeExecution, nrOfInstances);
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfInstances);
        if (nrOfInstances > 0) {
            this.setLoopVariable(scopeExecution, "loopCounter", 0);
            executions.add(scopeExecution);
        }
        return executions;
    }

    @Override
    public ActivityExecution createInnerInstance(ActivityExecution scopeExecution) {
        if (this.hasLoopVariable(scopeExecution, "nrOfActiveInstances") && this.getLoopVariable(scopeExecution, "nrOfActiveInstances") > 0) {
            throw LOG.unsupportedConcurrencyException(scopeExecution.toString(), this.getClass().getSimpleName());
        }
        int nrOfInstances = this.getLoopVariable(scopeExecution, "nrOfInstances");
        this.setLoopVariable(scopeExecution, "loopCounter", nrOfInstances);
        this.setLoopVariable(scopeExecution, "nrOfInstances", nrOfInstances + 1);
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", 1);
        return scopeExecution;
    }

    @Override
    public void destroyInnerInstance(ActivityExecution scopeExecution) {
        this.removeLoopVariable(scopeExecution, "loopCounter");
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances");
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances - 1);
    }
}

