/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cfg;

import java.util.ArrayList;
import java.util.Collection;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.cfg.standalone.StandaloneTransactionContextFactory;
import org.cibseven.bpm.engine.impl.interceptor.CommandContextFactory;
import org.cibseven.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.CommandCounterInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.CommandInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.LogInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.cibseven.bpm.engine.impl.interceptor.TxContextCommandContextFactory;

public abstract class AbstractTransactionProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    protected String transactionManagerJndiName;
    protected CommandContextFactory dbSchemaOperationsCommandContextFactory;

    public AbstractTransactionProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
    }

    protected abstract CommandInterceptor createTransactionInterceptor(boolean var1);

    protected abstract void initTransactionManager();

    @Override
    protected void init() {
        this.initTransactionManager();
        this.initDbSchemaOperationsCommandContextFactory();
        super.init();
    }

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequired = new ArrayList<CommandInterceptor>();
        if (!this.isDisableExceptionCode()) {
            defaultCommandInterceptorsTxRequired.add(this.getExceptionCodeInterceptor());
        }
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new CommandCounterInterceptor(this));
        defaultCommandInterceptorsTxRequired.add(new ProcessApplicationContextInterceptor(this));
        defaultCommandInterceptorsTxRequired.add(this.createTransactionInterceptor(false));
        defaultCommandInterceptorsTxRequired.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return defaultCommandInterceptorsTxRequired;
    }

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequiresNew = new ArrayList<CommandInterceptor>();
        if (!this.isDisableExceptionCode()) {
            defaultCommandInterceptorsTxRequiresNew.add(this.getExceptionCodeInterceptor());
        }
        defaultCommandInterceptorsTxRequiresNew.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequiresNew.add(new CommandCounterInterceptor(this));
        defaultCommandInterceptorsTxRequiresNew.add(new ProcessApplicationContextInterceptor(this));
        defaultCommandInterceptorsTxRequiresNew.add(this.createTransactionInterceptor(true));
        defaultCommandInterceptorsTxRequiresNew.add(new CommandContextInterceptor(this.commandContextFactory, this, true));
        return defaultCommandInterceptorsTxRequiresNew;
    }

    @Override
    protected void initCommandExecutorDbSchemaOperations() {
        if (this.commandExecutorSchemaOperations == null) {
            ArrayList<CommandInterceptor> commandInterceptorsDbSchemaOperations = new ArrayList<CommandInterceptor>();
            commandInterceptorsDbSchemaOperations.add(new LogInterceptor());
            commandInterceptorsDbSchemaOperations.add(new CommandCounterInterceptor(this));
            commandInterceptorsDbSchemaOperations.add(new CommandContextInterceptor(this.dbSchemaOperationsCommandContextFactory, this));
            commandInterceptorsDbSchemaOperations.add(this.actualCommandExecutor);
            this.commandExecutorSchemaOperations = this.initInterceptorChain(commandInterceptorsDbSchemaOperations);
        }
    }

    protected void initDbSchemaOperationsCommandContextFactory() {
        if (this.dbSchemaOperationsCommandContextFactory == null) {
            TxContextCommandContextFactory cmdContextFactory = new TxContextCommandContextFactory();
            cmdContextFactory.setProcessEngineConfiguration(this);
            cmdContextFactory.setTransactionContextFactory(new StandaloneTransactionContextFactory());
            this.dbSchemaOperationsCommandContextFactory = cmdContextFactory;
        }
    }

    public String getTransactionManagerJndiName() {
        return this.transactionManagerJndiName;
    }

    public void setTransactionManagerJndiName(String transactionManagerJndiName) {
        this.transactionManagerJndiName = transactionManagerJndiName;
    }

    public CommandContextFactory getDbSchemaOperationsCommandContextFactory() {
        return this.dbSchemaOperationsCommandContextFactory;
    }

    public void setDbSchemaOperationsCommandContextFactory(CommandContextFactory dbSchemaOperationsCommandContextFactory) {
        this.dbSchemaOperationsCommandContextFactory = dbSchemaOperationsCommandContextFactory;
    }
}

