/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cfg.standalone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.TransactionContext;
import org.cibseven.bpm.engine.impl.cfg.TransactionListener;
import org.cibseven.bpm.engine.impl.cfg.TransactionLogger;
import org.cibseven.bpm.engine.impl.cfg.TransactionState;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.db.PersistenceSession;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;

public class StandaloneTransactionContext
implements TransactionContext {
    private static final TransactionLogger LOG = ProcessEngineLogger.TX_LOGGER;
    protected CommandContext commandContext;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners = null;
    private TransactionState lastTransactionState;

    public StandaloneTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        List<TransactionListener> transactionListeners;
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new HashMap<TransactionState, List<TransactionListener>>();
        }
        if ((transactionListeners = this.stateTransactionListeners.get((Object)transactionState)) == null) {
            transactionListeners = new ArrayList<TransactionListener>();
            this.stateTransactionListeners.put(transactionState, transactionListeners);
        }
        transactionListeners.add(transactionListener);
    }

    @Override
    public void commit() {
        LOG.debugTransactionOperation("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING);
        LOG.debugTransactionOperation("committing the persistence session...");
        this.getPersistenceProvider().commit();
        LOG.debugTransactionOperation("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED);
    }

    protected void fireTransactionEvent(TransactionState transactionState) {
        this.setLastTransactionState(transactionState);
        if (this.stateTransactionListeners == null) {
            return;
        }
        List<TransactionListener> transactionListeners = this.stateTransactionListeners.get((Object)transactionState);
        if (transactionListeners == null) {
            return;
        }
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(this.commandContext);
        }
    }

    protected void setLastTransactionState(TransactionState transactionState) {
        this.lastTransactionState = transactionState;
    }

    private PersistenceSession getPersistenceProvider() {
        return this.commandContext.getSession(PersistenceSession.class);
    }

    @Override
    public void rollback() {
        try {
            try {
                LOG.debugTransactionOperation("firing event rollback...");
                this.fireTransactionEvent(TransactionState.ROLLINGBACK);
                LOG.debugTransactionOperation("rolling back the persistence session...");
                this.getPersistenceProvider().rollback();
            }
            catch (Throwable exception) {
                try {
                    LOG.exceptionWhileFiringEvent(TransactionState.ROLLINGBACK, exception);
                    Context.getCommandInvocationContext().trySetThrowable(exception);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    LOG.debugTransactionOperation("rolling back the persistence session...");
                    this.getPersistenceProvider().rollback();
                }
            }
        }
        catch (Throwable exception) {
            LOG.exceptionWhileFiringEvent(TransactionState.ROLLINGBACK, exception);
            Context.getCommandInvocationContext().trySetThrowable(exception);
        }
        finally {
            LOG.debugFiringEventRolledBack();
            this.fireTransactionEvent(TransactionState.ROLLED_BACK);
        }
    }

    @Override
    public boolean isTransactionActive() {
        return !TransactionState.ROLLINGBACK.equals((Object)this.lastTransactionState) && !TransactionState.ROLLED_BACK.equals((Object)this.lastTransactionState);
    }
}

