/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.filter.Filter;
import org.cibseven.bpm.engine.impl.AbstractQuery;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.FilterEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.query.Query;
import org.cibseven.bpm.engine.task.TaskQuery;

public abstract class AbstractExecuteFilterCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String filterId;
    protected Query<?, ?> extendingQuery;

    public AbstractExecuteFilterCmd(String filterId) {
        this.filterId = filterId;
    }

    public AbstractExecuteFilterCmd(String filterId, Query<?, ?> extendingQuery) {
        this.filterId = filterId;
        this.extendingQuery = extendingQuery;
    }

    protected Filter getFilter(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("No filter id given to execute", "filterId", (Object)this.filterId);
        FilterEntity filter = commandContext.getFilterManager().findFilterById(this.filterId);
        EnsureUtil.ensureNotNull("No filter found for id '" + this.filterId + "'", "filter", (Object)filter);
        if (this.extendingQuery != null) {
            ((AbstractQuery)this.extendingQuery).validate();
            filter = (FilterEntity)filter.extend(this.extendingQuery);
        }
        return filter;
    }

    protected Query<?, ?> getFilterQuery(CommandContext commandContext) {
        Filter filter = this.getFilter(commandContext);
        Object query = filter.getQuery();
        if (query instanceof TaskQuery) {
            ((TaskQuery)query).initializeFormKeys();
        }
        return query;
    }
}

