/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;
    protected String taskId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public DeleteAttachmentCmd(String taskId, String attachmentId) {
        this.taskId = taskId;
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity attachment = null;
        if (this.taskId != null) {
            attachment = (AttachmentEntity)commandContext.getAttachmentManager().findAttachmentByTaskIdAndAttachmentId(this.taskId, this.attachmentId);
            EnsureUtil.ensureNotNull("No attachment exist for task id '" + this.taskId + " and attachmentId '" + this.attachmentId + "'.", "attachment", (Object)attachment);
        } else {
            attachment = commandContext.getDbEntityManager().selectById(AttachmentEntity.class, this.attachmentId);
            EnsureUtil.ensureNotNull("No attachment exist with attachmentId '" + this.attachmentId + "'.", "attachment", (Object)attachment);
        }
        commandContext.getDbEntityManager().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null) {
            TaskEntity task = commandContext.getTaskManager().findTaskById(attachment.getTaskId());
            PropertyChange propertyChange = new PropertyChange("name", null, attachment.getName());
            commandContext.getOperationLogManager().logAttachmentOperation("DeleteAttachment", task, propertyChange);
            task.triggerUpdateEvent();
        }
        return null;
    }
}

