/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import org.cibseven.bpm.engine.impl.identity.IdentityOperationResult;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class DeleteTenantUserMembershipCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String tenantId;
    protected final String userId;

    public DeleteTenantUserMembershipCmd(String tenantId, String userId) {
        this.tenantId = tenantId;
        this.userId = userId;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("tenantId", (Object)this.tenantId);
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().deleteTenantUserMembership(this.tenantId, this.userId);
        commandContext.getOperationLogManager().logMembershipOperation(operationResult, this.userId, null, this.tenantId);
        return null;
    }
}

