/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.form.CamundaFormRef;
import org.cibseven.bpm.engine.impl.form.entity.CamundaFormDefinitionManager;
import org.cibseven.bpm.engine.impl.form.handler.DefaultFormHandler;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.CamundaFormDefinitionEntity;
import org.cibseven.bpm.engine.repository.CamundaFormDefinition;

public class GetCamundaFormDefinitionCmd
implements Command<CamundaFormDefinition> {
    protected CamundaFormRef camundaFormRef;
    protected String deploymentId;

    public GetCamundaFormDefinitionCmd(CamundaFormRef camundaFormRef, String deploymentId) {
        this.camundaFormRef = camundaFormRef;
        this.deploymentId = deploymentId;
    }

    @Override
    public CamundaFormDefinition execute(CommandContext commandContext) {
        String binding = this.camundaFormRef.getBinding();
        String key = this.camundaFormRef.getKey();
        CamundaFormDefinitionEntity definition = null;
        CamundaFormDefinitionManager manager = commandContext.getCamundaFormDefinitionManager();
        if (binding.equals("deployment")) {
            definition = manager.findDefinitionByDeploymentAndKey(this.deploymentId, key);
        } else if (binding.equals("latest")) {
            definition = manager.findLatestDefinitionByKey(key);
        } else if (binding.equals("version")) {
            definition = manager.findDefinitionByKeyVersionAndTenantId(key, this.camundaFormRef.getVersion(), null);
        } else {
            throw new BadUserRequestException("Unsupported binding type for camundaFormRef. Expected to be one of " + DefaultFormHandler.ALLOWED_FORM_REF_BINDINGS + " but was:" + binding);
        }
        return definition;
    }
}

