/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.nio.charset.StandardCharsets;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.LicenseCmd;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ResourceEntity;

public class GetLicenseKeyCmd
extends LicenseCmd
implements Command<String> {
    @Override
    public String execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkReadLicenseKey);
        ResourceEntity licenseResource = commandContext.getResourceManager().findLicenseKeyResource();
        if (licenseResource != null) {
            return new String(licenseResource.getBytes(), StandardCharsets.UTF_8);
        }
        PropertyEntity licenseProperty = commandContext.getPropertyManager().findPropertyById("camunda-license-key");
        if (licenseProperty != null) {
            return licenseProperty.getValue();
        }
        return null;
    }
}

