/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.Collection;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.form.FormField;
import org.cibseven.bpm.engine.form.TaskFormData;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskManager;
import org.cibseven.bpm.engine.impl.task.TaskDefinition;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.variable.VariableMap;
import org.cibseven.bpm.engine.variable.impl.VariableMapImpl;

public class GetTaskFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetTaskFormVariablesCmd(String taskId, Collection<String> variableNames, boolean deserializeObjectValues) {
        super(taskId, variableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.resourceId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find task with id '" + this.resourceId + "'.", "task", (Object)task);
        this.checkGetTaskFormVariables(task, commandContext);
        VariableMapImpl result = new VariableMapImpl();
        TaskDefinition taskDefinition = task.getTaskDefinition();
        if (taskDefinition != null) {
            TaskFormData taskFormData = taskDefinition.getTaskFormHandler().createTaskForm(task);
            for (FormField formField : taskFormData.getFormFields()) {
                if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
                result.put(formField.getId(), (Object)this.createVariable(formField, task));
            }
        }
        task.collectVariables(result, this.formVariableNames, false, this.deserializeObjectValues);
        return result;
    }

    protected void checkGetTaskFormVariables(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
    }
}

