/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class RegisterDeploymentCmd
implements Command<Void> {
    protected String deploymentId;

    public RegisterDeploymentCmd(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DeploymentEntity deployment = commandContext.getDeploymentManager().findDeploymentById(this.deploymentId);
        EnsureUtil.ensureNotNull("Deployment " + this.deploymentId + " does not exist", "deployment", (Object)deployment);
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkRegisterDeployment);
        Context.getProcessEngineConfiguration().getRegisteredDeployments().add(this.deploymentId);
        return null;
    }
}

