/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.Collection;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.AbstractRemoveVariableCmd;
import org.cibseven.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class RemoveTaskVariablesCmd
extends AbstractRemoveVariableCmd {
    private static final long serialVersionUID = 1L;

    public RemoveTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        super(taskId, variableNames, isLocal);
    }

    @Override
    protected TaskEntity getEntity() {
        EnsureUtil.ensureNotNull("taskId", (Object)this.entityId);
        TaskEntity task = this.commandContext.getTaskManager().findTaskById(this.entityId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.entityId, "task", (Object)task);
        this.checkRemoveTaskVariables(task);
        return task;
    }

    @Override
    protected ExecutionEntity getContextExecution() {
        return this.getEntity().getExecution();
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        TaskEntity task = (TaskEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), null, task.getId(), PropertyChange.EMPTY_CHANGE);
    }

    protected void checkRemoveTaskVariables(TaskEntity task) {
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateTaskVariable(task);
        }
    }
}

