/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.identity.User;
import org.cibseven.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import org.cibseven.bpm.engine.impl.identity.IdentityOperationResult;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.UserEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class SaveUserCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected User user;
    protected boolean skipPasswordPolicy;

    public SaveUserCmd(User user) {
        this(user, false);
    }

    public SaveUserCmd(User user, boolean skipPasswordPolicy) {
        this.user = user;
        this.skipPasswordPolicy = skipPasswordPolicy;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("user", (Object)this.user);
        EnsureUtil.ensureWhitelistedResourceId(commandContext, "User", this.user.getId());
        if (this.user instanceof UserEntity) {
            this.validateUserEntity(commandContext);
        }
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().saveUser(this.user);
        commandContext.getOperationLogManager().logUserOperation(operationResult, this.user.getId());
        return null;
    }

    private void validateUserEntity(CommandContext commandContext) {
        if (this.shouldCheckPasswordPolicy(commandContext) && !((UserEntity)this.user).checkPasswordAgainstPolicy()) {
            throw new ProcessEngineException("Password does not match policy");
        }
    }

    protected boolean shouldCheckPasswordPolicy(CommandContext commandContext) {
        return ((UserEntity)this.user).hasNewPassword() && !this.skipPasswordPolicy && commandContext.getProcessEngineConfiguration().isEnablePasswordPolicy();
    }
}

