/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.ProcessEngineServices;
import org.cibseven.bpm.engine.delegate.CmmnModelExecutionContext;
import org.cibseven.bpm.engine.delegate.ProcessEngineServicesAware;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import org.cibseven.bpm.engine.impl.cmmn.execution.CaseSentryPartImpl;
import org.cibseven.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.cibseven.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.cibseven.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.cibseven.bpm.engine.impl.core.variable.scope.SimpleVariableInstance;
import org.cibseven.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.cibseven.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.cibseven.bpm.engine.impl.core.variable.scope.VariableStore;
import org.cibseven.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.cibseven.bpm.engine.impl.pvm.runtime.ExecutionImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.cibseven.bpm.model.cmmn.CmmnModelInstance;
import org.cibseven.bpm.model.cmmn.instance.CmmnElement;

public class CaseExecutionImpl
extends CmmnExecution
implements Serializable {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;
    private static final long serialVersionUID = 1L;
    protected List<CaseExecutionImpl> caseExecutions;
    protected List<CaseSentryPartImpl> caseSentryParts;
    protected CaseExecutionImpl caseInstance;
    protected CaseExecutionImpl parent;
    protected ExecutionImpl subProcessInstance;
    protected ExecutionImpl superExecution;
    protected CaseExecutionImpl subCaseInstance;
    protected CaseExecutionImpl superCaseExecution;
    protected VariableStore<SimpleVariableInstance> variableStore = new VariableStore();

    @Override
    public String getCaseDefinitionId() {
        return this.getCaseDefinition().getId();
    }

    @Override
    public CaseExecutionImpl getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CmmnExecution parent) {
        this.parent = (CaseExecutionImpl)parent;
    }

    @Override
    public String getParentId() {
        return this.getParent().getId();
    }

    @Override
    public String getActivityId() {
        return this.getActivity().getId();
    }

    @Override
    public String getActivityName() {
        return this.getActivity().getName();
    }

    public List<CaseExecutionImpl> getCaseExecutions() {
        return new ArrayList<CaseExecutionImpl>(this.getCaseExecutionsInternal());
    }

    protected List<CaseExecutionImpl> getCaseExecutionsInternal() {
        if (this.caseExecutions == null) {
            this.caseExecutions = new ArrayList<CaseExecutionImpl>();
        }
        return this.caseExecutions;
    }

    @Override
    public CaseExecutionImpl getCaseInstance() {
        return this.caseInstance;
    }

    @Override
    public void setCaseInstance(CmmnExecution caseInstance) {
        this.caseInstance = (CaseExecutionImpl)caseInstance;
    }

    @Override
    public ExecutionImpl getSuperExecution() {
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        this.superExecution = (ExecutionImpl)superExecution;
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionImpl)subProcessInstance;
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        return this.createSubProcessInstance(processDefinition, businessKey, this.getCaseInstanceId());
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ExecutionImpl subProcessInstance = (ExecutionImpl)processDefinition.createProcessInstance(businessKey, caseInstanceId);
        subProcessInstance.setSuperCaseExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        return subProcessInstance;
    }

    @Override
    public CaseExecutionImpl getSubCaseInstance() {
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionImpl)subCaseInstance;
    }

    @Override
    public CaseExecutionImpl createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionImpl createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionImpl caseInstance = (CaseExecutionImpl)caseDefinition.createCaseInstance(businessKey);
        this.subCaseInstance.setSuperCaseExecution(this);
        this.setSubCaseInstance(this.subCaseInstance);
        return caseInstance;
    }

    @Override
    public CaseExecutionImpl getSuperCaseExecution() {
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionImpl)superCaseExecution;
    }

    public List<CaseSentryPartImpl> getCaseSentryParts() {
        if (this.caseSentryParts == null) {
            this.caseSentryParts = new ArrayList<CaseSentryPartImpl>();
        }
        return this.caseSentryParts;
    }

    @Override
    protected Map<String, List<CmmnSentryPart>> getSentries() {
        HashMap<String, List<CmmnSentryPart>> sentries = new HashMap<String, List<CmmnSentryPart>>();
        for (CaseSentryPartImpl sentryPart : this.getCaseSentryParts()) {
            String sentryId = sentryPart.getSentryId();
            ArrayList<CaseSentryPartImpl> parts = (ArrayList<CaseSentryPartImpl>)sentries.get(sentryId);
            if (parts == null) {
                parts = new ArrayList<CaseSentryPartImpl>();
                sentries.put(sentryId, parts);
            }
            parts.add(sentryPart);
        }
        return sentries;
    }

    protected List<CaseSentryPartImpl> findSentry(String sentryId) {
        ArrayList<CaseSentryPartImpl> result = new ArrayList<CaseSentryPartImpl>();
        for (CaseSentryPartImpl sentryPart : this.getCaseSentryParts()) {
            if (!sentryPart.getSentryId().equals(sentryId)) continue;
            result.add(sentryPart);
        }
        return result;
    }

    @Override
    protected void addSentryPart(CmmnSentryPart sentryPart) {
        this.getCaseSentryParts().add((CaseSentryPartImpl)sentryPart);
    }

    @Override
    protected CmmnSentryPart newSentryPart() {
        return new CaseSentryPartImpl();
    }

    @Override
    protected CaseExecutionImpl createCaseExecution(CmmnActivity activity) {
        CaseExecutionImpl child = this.newCaseExecution();
        child.setActivity(activity);
        child.setParent(this);
        this.getCaseExecutionsInternal().add(child);
        child.setCaseInstance(this.getCaseInstance());
        child.setCaseDefinition(this.getCaseDefinition());
        return child;
    }

    @Override
    protected CaseExecutionImpl newCaseExecution() {
        return new CaseExecutionImpl();
    }

    @Override
    protected VariableStore<CoreVariableInstance> getVariableStore() {
        return this.variableStore;
    }

    @Override
    protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
        return SimpleVariableInstance.SimpleVariableInstanceFactory.INSTANCE;
    }

    @Override
    protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        throw LOG.unsupportedTransientOperationException(ProcessEngineServicesAware.class.getName());
    }

    @Override
    public ProcessEngine getProcessEngine() {
        throw LOG.unsupportedTransientOperationException(ProcessEngineServicesAware.class.getName());
    }

    @Override
    public CmmnElement getCmmnModelElementInstance() {
        throw LOG.unsupportedTransientOperationException(CmmnModelExecutionContext.class.getName());
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance() {
        throw LOG.unsupportedTransientOperationException(CmmnModelExecutionContext.class.getName());
    }
}

