/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.dmn.result;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cibseven.bpm.dmn.engine.DmnDecisionResult;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.dmn.DecisionLogger;
import org.cibseven.bpm.engine.impl.dmn.result.DecisionResultMapper;

public class CollectEntriesDecisionResultMapper
implements DecisionResultMapper {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;

    @Override
    public Object mapDecisionResult(DmnDecisionResult decisionResult) {
        if (decisionResult.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> outputNames = this.collectOutputNames(decisionResult);
        if (outputNames.size() > 1) {
            throw LOG.decisionResultCollectMappingException(outputNames, decisionResult, this);
        }
        String outputName = outputNames.iterator().next();
        return decisionResult.collectEntries(outputName);
    }

    protected Set<String> collectOutputNames(DmnDecisionResult decisionResult) {
        HashSet<String> outputNames = new HashSet<String>();
        for (Map entryMap : decisionResult.getResultList()) {
            outputNames.addAll(entryMap.keySet());
        }
        return outputNames;
    }

    public String toString() {
        return "CollectEntriesDecisionResultMapper{}";
    }
}

