/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.form.type;

import java.util.Map;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.form.type.SimpleFormFieldType;
import org.cibseven.bpm.engine.variable.Variables;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class EnumFormType
extends SimpleFormFieldType {
    public static final String TYPE_NAME = "enum";
    protected Map<String, String> values;

    public EnumFormType(Map<String, String> values) {
        this.values = values;
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public Object getInformation(String key) {
        if (key.equals("values")) {
            return this.values;
        }
        return null;
    }

    @Override
    public TypedValue convertValue(TypedValue propertyValue) {
        Object value = propertyValue.getValue();
        if (value == null || String.class.isInstance(value)) {
            this.validateValue(value);
            return Variables.stringValue((String)((String)value), (boolean)propertyValue.isTransient());
        }
        throw new ProcessEngineException("Value '" + value + "' is not of type String.");
    }

    protected void validateValue(Object value) {
        if (value != null && this.values != null && !this.values.containsKey(value)) {
            throw new ProcessEngineException("Invalid value for enum form property: " + value);
        }
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        this.validateValue(propertyValue);
        return propertyValue;
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue != null) {
            if (!(modelValue instanceof String)) {
                throw new ProcessEngineException("Model value should be a String");
            }
            this.validateValue(modelValue);
        }
        return (String)modelValue;
    }
}

