/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.history.parser;

import org.cibseven.bpm.engine.delegate.DelegateTask;
import org.cibseven.bpm.engine.delegate.TaskListener;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.history.HistoryLevel;
import org.cibseven.bpm.engine.impl.history.event.HistoryEvent;
import org.cibseven.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.cibseven.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;

public abstract class HistoryTaskListener
implements TaskListener {
    protected final HistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    public HistoryTaskListener(HistoryEventProducer historyEventProducer) {
        this.eventProducer = historyEventProducer;
    }

    @Override
    public void notify(DelegateTask task) {
        HistoryEvent historyEvent;
        HistoryEventHandler historyEventHandler = Context.getProcessEngineConfiguration().getHistoryEventHandler();
        ExecutionEntity execution = ((TaskEntity)task).getExecution();
        if (execution != null && (historyEvent = this.createHistoryEvent(task, execution)) != null) {
            historyEventHandler.handleEvent(historyEvent);
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }

    protected abstract HistoryEvent createHistoryEvent(DelegateTask var1, ExecutionEntity var2);
}

