/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.interceptor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.cibseven.bpm.application.ProcessApplicationReference;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.commons.logging.MdcAccess;

public class ProcessDataContext {
    protected static final String NULL_VALUE = "~NULL_VALUE~";
    protected String mdcPropertyActivityId;
    protected String mdcPropertyActivityName;
    protected String mdcPropertyApplicationName;
    protected String mdcPropertyBusinessKey;
    protected String mdcPropertyDefinitionId;
    protected String mdcPropertyDefinitionKey;
    protected String mdcPropertyInstanceId;
    protected String mdcPropertyTenantId;
    protected String mdcPropertyEngineName;
    protected boolean handleMdc = false;
    protected ProcessDataStack activityIdStack;
    protected Map<String, ProcessDataStack> mdcDataStacks = new HashMap<String, ProcessDataStack>();
    protected ProcessDataSections sections = new ProcessDataSections();
    protected Map<String, String> externalProperties = new HashMap<String, String>();

    public ProcessDataContext(ProcessEngineConfigurationImpl configuration) {
        this(configuration, false, false);
    }

    public ProcessDataContext(ProcessEngineConfigurationImpl configuration, boolean initFromCurrentMdc) {
        this(configuration, initFromCurrentMdc, false);
    }

    public ProcessDataContext(ProcessEngineConfigurationImpl configuration, boolean initFromCurrentMdc, boolean parkExternalProperties) {
        this.mdcPropertyActivityId = configuration.getLoggingContextActivityId();
        this.activityIdStack = new ProcessDataStack(ProcessDataContext.isNotBlank(this.mdcPropertyActivityId) ? this.mdcPropertyActivityId : null);
        if (ProcessDataContext.isNotBlank(this.mdcPropertyActivityId)) {
            this.mdcDataStacks.put(this.mdcPropertyActivityId, this.activityIdStack);
        }
        this.mdcPropertyActivityName = this.initProperty(configuration::getLoggingContextActivityName);
        this.mdcPropertyApplicationName = this.initProperty(configuration::getLoggingContextApplicationName);
        this.mdcPropertyBusinessKey = this.initProperty(configuration::getLoggingContextBusinessKey);
        this.mdcPropertyDefinitionId = this.initProperty(configuration::getLoggingContextProcessDefinitionId);
        this.mdcPropertyDefinitionKey = this.initProperty(configuration::getLoggingContextProcessDefinitionKey);
        this.mdcPropertyInstanceId = this.initProperty(configuration::getLoggingContextProcessInstanceId);
        this.mdcPropertyTenantId = this.initProperty(configuration::getLoggingContextTenantId);
        this.mdcPropertyEngineName = this.initProperty(configuration::getLoggingContextEngineName);
        if (parkExternalProperties) {
            this.parkExternalProperties(configuration);
        }
        boolean bl = this.handleMdc = !this.mdcDataStacks.isEmpty();
        if (initFromCurrentMdc) {
            this.mdcDataStacks.values().forEach(stack -> {
                boolean valuePushed = stack.pushCurrentValueFromMdc();
                if (valuePushed) {
                    this.sections.addToCurrentSection((ProcessDataStack)stack);
                }
            });
            this.sections.sealCurrentSection();
        }
    }

    protected void parkExternalProperties(ProcessEngineConfigurationImpl configuration) {
        this.parkExternalMDCProperty(configuration::getLoggingContextActivityId);
        this.parkExternalMDCProperty(configuration::getLoggingContextActivityName);
        this.parkExternalMDCProperty(configuration::getLoggingContextApplicationName);
        this.parkExternalMDCProperty(configuration::getLoggingContextBusinessKey);
        this.parkExternalMDCProperty(configuration::getLoggingContextProcessDefinitionId);
        this.parkExternalMDCProperty(configuration::getLoggingContextProcessDefinitionKey);
        this.parkExternalMDCProperty(configuration::getLoggingContextProcessInstanceId);
        this.parkExternalMDCProperty(configuration::getLoggingContextTenantId);
        this.parkExternalMDCProperty(configuration::getLoggingContextEngineName);
    }

    protected String initProperty(Supplier<String> configSupplier) {
        String configValue = configSupplier.get();
        if (ProcessDataContext.isNotBlank(configValue)) {
            this.mdcDataStacks.put(configValue, new ProcessDataStack(configValue));
        }
        return configValue;
    }

    protected String parkExternalMDCProperty(Supplier<String> configSupplier) {
        String configValue = configSupplier.get();
        if (ProcessDataContext.isNotBlank(configValue) && ProcessDataContext.isNotBlank(MdcAccess.get((String)configValue))) {
            this.externalProperties.put(configValue, MdcAccess.get((String)configValue));
        }
        return configValue;
    }

    public boolean pushSection(ExecutionEntity execution) {
        ProcessApplicationReference currentPa;
        if (this.handleMdc && this.hasNoMdcValues()) {
            this.clearMdc();
        }
        int numSections = this.sections.size();
        this.addToStack(this.activityIdStack, execution.getActivityId());
        this.addToStack(execution.getCurrentActivityName(), this.mdcPropertyActivityName);
        this.addToStack(execution.getProcessDefinitionId(), this.mdcPropertyDefinitionId);
        this.addToStack(execution.getProcessInstanceId(), this.mdcPropertyInstanceId);
        this.addToStack(execution.getTenantId(), this.mdcPropertyTenantId);
        this.addToStack(execution.getProcessEngine().getName(), this.mdcPropertyEngineName);
        if (ProcessDataContext.isNotBlank(this.mdcPropertyApplicationName) && (currentPa = Context.getCurrentProcessApplication()) != null) {
            this.addToStack(currentPa.getName(), this.mdcPropertyApplicationName);
        }
        if (ProcessDataContext.isNotBlank(this.mdcPropertyBusinessKey)) {
            this.addToStack(execution.getBusinessKey(), this.mdcPropertyBusinessKey);
        }
        if (ProcessDataContext.isNotBlank(this.mdcPropertyDefinitionKey)) {
            this.addToStack(execution.getProcessDefinition().getKey(), this.mdcPropertyDefinitionKey);
        }
        this.sections.sealCurrentSection();
        boolean newSectionCreated = numSections != this.sections.size();
        return newSectionCreated;
    }

    protected boolean hasNoMdcValues() {
        return this.mdcDataStacks.values().stream().allMatch(ProcessDataStack::isEmpty);
    }

    public void popSection() {
        this.sections.popCurrentSection();
    }

    public void clearMdc() {
        if (this.handleMdc) {
            this.mdcDataStacks.values().forEach(ProcessDataStack::clearMdcProperty);
        }
    }

    public void restoreExternalMDCProperties() {
        this.externalProperties.forEach(MdcAccess::put);
    }

    public void updateMdcFromCurrentValues() {
        if (this.handleMdc) {
            this.mdcDataStacks.values().forEach(ProcessDataStack::updateMdcWithCurrentValue);
        }
    }

    public String getLatestActivityId() {
        return this.activityIdStack.getCurrentValue();
    }

    protected void addToStack(String value, String property) {
        if (!ProcessDataContext.isNotBlank(property)) {
            return;
        }
        ProcessDataStack stack = this.mdcDataStacks.get(property);
        this.addToStack(stack, value);
    }

    protected void addToStack(ProcessDataStack stack, String value) {
        String current = stack.getCurrentValue();
        if (ProcessDataContext.valuesEqual(current, value)) {
            return;
        }
        stack.pushCurrentValue(value);
        this.sections.addToCurrentSection(stack);
    }

    protected static boolean isNotBlank(String property) {
        return property != null && !property.trim().isEmpty();
    }

    protected static boolean valuesEqual(String val1, String val2) {
        if (ProcessDataContext.isNull(val1)) {
            return val2 == null;
        }
        return val1.equals(val2);
    }

    protected static boolean isNull(String value) {
        return value == null || NULL_VALUE.equals(value);
    }

    protected static class ProcessDataSections {
        protected Deque<List<ProcessDataStack>> sections = new ArrayDeque<List<ProcessDataStack>>();
        protected boolean currentSectionSealed = true;

        protected ProcessDataSections() {
        }

        public void addToCurrentSection(ProcessDataStack stack) {
            List<Object> currentSection;
            if (this.currentSectionSealed) {
                currentSection = new ArrayList();
                this.sections.addFirst(currentSection);
                this.currentSectionSealed = false;
            } else {
                currentSection = this.sections.peekFirst();
            }
            currentSection.add(stack);
        }

        public void popCurrentSection() {
            List<ProcessDataStack> section = this.sections.pollFirst();
            if (section != null) {
                section.forEach(ProcessDataStack::removeCurrentValue);
            }
            this.currentSectionSealed = true;
        }

        public void sealCurrentSection() {
            this.currentSectionSealed = true;
        }

        public int size() {
            return this.sections.size();
        }
    }

    protected static class ProcessDataStack {
        protected String mdcName;
        protected Deque<String> deque = new ArrayDeque<String>();

        public ProcessDataStack(String mdcName) {
            this.mdcName = mdcName;
        }

        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        public String getCurrentValue() {
            return this.deque.peekFirst();
        }

        public void pushCurrentValue(String value) {
            this.deque.addFirst(value != null ? value : ProcessDataContext.NULL_VALUE);
            this.updateMdcWithCurrentValue();
        }

        public boolean pushCurrentValueFromMdc() {
            if (ProcessDataContext.isNotBlank(this.mdcName)) {
                String mdcValue = MdcAccess.get((String)this.mdcName);
                this.deque.addFirst(mdcValue != null ? mdcValue : ProcessDataContext.NULL_VALUE);
                return true;
            }
            return false;
        }

        public void removeCurrentValue() {
            this.deque.removeFirst();
            this.updateMdcWithCurrentValue();
        }

        public void clearMdcProperty() {
            if (ProcessDataContext.isNotBlank(this.mdcName)) {
                MdcAccess.remove((String)this.mdcName);
            }
        }

        public void updateMdcWithCurrentValue() {
            if (ProcessDataContext.isNotBlank(this.mdcName)) {
                String currentValue = this.getCurrentValue();
                if (ProcessDataContext.isNull(currentValue)) {
                    MdcAccess.remove((String)this.mdcName);
                } else {
                    MdcAccess.put((String)this.mdcName, (String)currentValue);
                }
            }
        }
    }
}

