/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor;

import org.cibseven.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import org.cibseven.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import org.cibseven.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.cibseven.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.MessageEntity;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.AtomicOperation;

public class MessageJobDeclaration
extends JobDeclaration<AtomicOperationInvocation, MessageEntity> {
    public static final String ASYNC_BEFORE = "async-before";
    public static final String ASYNC_AFTER = "async-after";
    private static final long serialVersionUID = 1L;
    protected String[] operationIdentifier;

    public MessageJobDeclaration(String[] operationsIdentifier) {
        super("async-continuation");
        this.operationIdentifier = operationsIdentifier;
    }

    @Override
    protected MessageEntity newJobInstance(AtomicOperationInvocation context) {
        MessageEntity message = new MessageEntity();
        message.setExecution(context.getExecution());
        return message;
    }

    public boolean isApplicableForOperation(AtomicOperation operation) {
        for (String identifier : this.operationIdentifier) {
            if (!operation.getCanonicalName().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ExecutionEntity resolveExecution(AtomicOperationInvocation context) {
        return context.getExecution();
    }

    @Override
    protected JobHandlerConfiguration resolveJobHandlerConfiguration(AtomicOperationInvocation context) {
        AsyncContinuationJobHandler.AsyncContinuationConfiguration configuration = new AsyncContinuationJobHandler.AsyncContinuationConfiguration();
        configuration.setAtomicOperation(context.getOperation().getCanonicalName());
        ExecutionEntity execution = context.getExecution();
        ActivityImpl activity = execution.getActivity();
        if (activity != null && activity.isAsyncAfter() && execution.getTransition() != null) {
            configuration.setTransitionId(execution.getTransition().getId());
        }
        return configuration;
    }
}

