/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor;

import java.util.Iterator;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineImpl;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.cibseven.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.cibseven.bpm.engine.impl.jobexecutor.BackoffJobAcquisitionStrategy;
import org.cibseven.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.cibseven.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutor;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.cibseven.bpm.engine.impl.util.ClassLoaderUtil;

public class SequentialJobAcquisitionRunnable
extends AcquireJobsRunnable {
    protected final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected JobAcquisitionContext acquisitionContext = this.initializeAcquisitionContext();

    public SequentialJobAcquisitionRunnable(JobExecutor jobExecutor) {
        super(jobExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        this.LOG.startingToAcquireJobs(this.jobExecutor.getName());
        JobAcquisitionStrategy acquisitionStrategy = this.initializeAcquisitionStrategy();
        while (!this.isInterrupted) {
            this.acquisitionContext.reset();
            this.acquisitionContext.setAcquisitionTime(System.currentTimeMillis());
            Iterator<ProcessEngineImpl> engineIterator = this.jobExecutor.engineIterator();
            ClassLoader classLoaderBeforeExecution = ClassLoaderUtil.switchToProcessEngineClassloader();
            try {
                while (engineIterator.hasNext()) {
                    ProcessEngineImpl currentProcessEngine = engineIterator.next();
                    if (!this.jobExecutor.hasRegisteredEngine(currentProcessEngine)) continue;
                    AcquiredJobs acquiredJobs = this.acquireJobs(this.acquisitionContext, acquisitionStrategy, currentProcessEngine);
                    this.executeJobs(this.acquisitionContext, currentProcessEngine, acquiredJobs);
                }
            }
            catch (Exception e) {
                this.LOG.exceptionDuringJobAcquisition(e);
                this.acquisitionContext.setAcquisitionException(e);
            }
            finally {
                ClassLoaderUtil.setContextClassloader(classLoaderBeforeExecution);
            }
            this.acquisitionContext.setJobAdded(this.isJobAdded);
            this.configureNextAcquisitionCycle(this.acquisitionContext, acquisitionStrategy);
            this.clearJobAddedNotification();
            long waitTime = acquisitionStrategy.getWaitTime();
            waitTime = Math.max(0L, this.acquisitionContext.getAcquisitionTime() + waitTime - System.currentTimeMillis());
            this.suspendAcquisition(waitTime);
        }
        this.LOG.stoppedJobAcquisition(this.jobExecutor.getName());
    }

    protected JobAcquisitionContext initializeAcquisitionContext() {
        return new JobAcquisitionContext();
    }

    protected void configureNextAcquisitionCycle(JobAcquisitionContext acquisitionContext, JobAcquisitionStrategy acquisitionStrategy) {
        acquisitionStrategy.reconfigure(acquisitionContext);
    }

    protected JobAcquisitionStrategy initializeAcquisitionStrategy() {
        return new BackoffJobAcquisitionStrategy(this.jobExecutor);
    }

    public JobAcquisitionContext getAcquisitionContext() {
        return this.acquisitionContext;
    }

    protected void executeJobs(JobAcquisitionContext context, ProcessEngineImpl currentProcessEngine, AcquiredJobs acquiredJobs) {
        List<List<String>> additionalJobs = context.getAdditionalJobsByEngine().get(currentProcessEngine.getName());
        if (additionalJobs != null) {
            for (List<String> jobBatch : additionalJobs) {
                this.LOG.executeJobs(currentProcessEngine.getName(), jobBatch);
                this.jobExecutor.executeJobs(jobBatch, currentProcessEngine);
            }
        }
        for (List<String> jobIds : acquiredJobs.getJobIdBatches()) {
            this.LOG.executeJobs(currentProcessEngine.getName(), jobIds);
            this.jobExecutor.executeJobs(jobIds, currentProcessEngine);
        }
    }

    protected AcquiredJobs acquireJobs(JobAcquisitionContext context, JobAcquisitionStrategy acquisitionStrategy, ProcessEngineImpl currentProcessEngine) {
        CommandExecutor commandExecutor = currentProcessEngine.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        int numJobsToAcquire = acquisitionStrategy.getNumJobsToAcquire(currentProcessEngine.getName());
        AcquiredJobs acquiredJobs = null;
        if (numJobsToAcquire > 0) {
            this.jobExecutor.logAcquisitionAttempt(currentProcessEngine);
            acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd(numJobsToAcquire));
        } else {
            acquiredJobs = new AcquiredJobs(numJobsToAcquire);
        }
        context.submitAcquiredJobs(currentProcessEngine.getName(), acquiredJobs);
        this.jobExecutor.logAcquiredJobs(currentProcessEngine, acquiredJobs.size());
        this.jobExecutor.logAcquisitionFailureJobs(currentProcessEngine, acquiredJobs.getNumberOfJobsFailedToLock());
        this.LOG.acquiredJobs(currentProcessEngine.getName(), acquiredJobs);
        return acquiredJobs;
    }
}

