/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Date;
import java.util.Map;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.cibseven.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.cibseven.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.cibseven.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.cibseven.bpm.engine.impl.persistence.entity.JobEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.SuspensionState;
import org.cibseven.bpm.engine.impl.util.ClockUtil;

public class HistoryCleanupSchedulerCmd
implements Command<Void> {
    protected static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected boolean isRescheduleNow;
    protected HistoryCleanupJobHandlerConfiguration configuration;
    protected String jobId;
    protected Map<String, Long> reports;

    public HistoryCleanupSchedulerCmd(boolean isRescheduleNow, Map<String, Long> reports, HistoryCleanupJobHandlerConfiguration configuration, String jobId) {
        this.isRescheduleNow = isRescheduleNow;
        this.configuration = configuration;
        this.jobId = jobId;
        this.reports = reports;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Date nextRunDate;
        this.reportMetrics(commandContext);
        JobEntity jobEntity = commandContext.getJobManager().findJobById(this.jobId);
        boolean rescheduled = false;
        if (this.isRescheduleNow) {
            commandContext.getJobManager().reschedule(jobEntity, ClockUtil.getCurrentTime());
            rescheduled = true;
            this.cancelCountEmptyRuns(this.configuration, jobEntity);
        } else if (HistoryCleanupHelper.isWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext.getProcessEngineConfiguration()) && HistoryCleanupHelper.isWithinBatchWindow(nextRunDate = this.configuration.getNextRunWithDelay(ClockUtil.getCurrentTime()), commandContext.getProcessEngineConfiguration())) {
            commandContext.getJobManager().reschedule(jobEntity, nextRunDate);
            rescheduled = true;
            this.incrementCountEmptyRuns(this.configuration, jobEntity);
        }
        if (!rescheduled) {
            if (HistoryCleanupHelper.isBatchWindowConfigured(commandContext)) {
                this.rescheduleRegularCall(commandContext, jobEntity);
            } else {
                this.suspendJob(jobEntity);
            }
            this.cancelCountEmptyRuns(this.configuration, jobEntity);
        }
        return null;
    }

    protected void rescheduleRegularCall(CommandContext commandContext, JobEntity jobEntity) {
        BatchWindow nextBatchWindow = commandContext.getProcessEngineConfiguration().getBatchWindowManager().getNextBatchWindow(ClockUtil.getCurrentTime(), commandContext.getProcessEngineConfiguration());
        if (nextBatchWindow != null) {
            commandContext.getJobManager().reschedule(jobEntity, nextBatchWindow.getStart());
        } else {
            LOG.warnHistoryCleanupBatchWindowNotFound();
            this.suspendJob(jobEntity);
        }
    }

    protected void suspendJob(JobEntity jobEntity) {
        jobEntity.setSuspensionState(SuspensionState.SUSPENDED.getStateCode());
    }

    protected void incrementCountEmptyRuns(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
        configuration.setCountEmptyRuns(configuration.getCountEmptyRuns() + 1);
        jobEntity.setJobHandlerConfiguration(configuration);
    }

    protected void cancelCountEmptyRuns(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
        configuration.setCountEmptyRuns(0);
        jobEntity.setJobHandlerConfiguration(configuration);
    }

    protected void reportMetrics(CommandContext commandContext) {
        ProcessEngineConfigurationImpl engineConfiguration = commandContext.getProcessEngineConfiguration();
        if (engineConfiguration.isHistoryCleanupMetricsEnabled()) {
            for (Map.Entry<String, Long> report : this.reports.entrySet()) {
                engineConfiguration.getDbMetricsReporter().reportValueAtOnce(report.getKey(), report.getValue());
            }
        }
    }
}

