/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.instance;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.cibseven.bpm.engine.impl.tree.TreeVisitor;

public class DeleteUnmappedInstanceVisitor
implements TreeVisitor<MigratingScopeInstance> {
    protected Set<MigratingScopeInstance> visitedInstances = new HashSet<MigratingScopeInstance>();
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    public DeleteUnmappedInstanceVisitor(boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
    }

    @Override
    public void visit(MigratingScopeInstance currentInstance) {
        this.visitedInstances.add(currentInstance);
        if (!currentInstance.migrates()) {
            HashSet<MigratingProcessElementInstance> children = new HashSet<MigratingProcessElementInstance>(currentInstance.getChildren());
            MigratingScopeInstance parent = currentInstance.getParent();
            currentInstance.detachChildren();
            currentInstance.remove(this.skipCustomListeners, this.skipIoMappings);
            for (MigratingProcessElementInstance child : children) {
                child.attachState(parent);
            }
        } else {
            currentInstance.removeUnmappedDependentInstances();
        }
    }

    public boolean hasVisitedAll(Collection<MigratingScopeInstance> activityInstances) {
        return this.visitedInstances.containsAll(activityInstances);
    }
}

