/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.externaltask.ExternalTask;
import org.cibseven.bpm.engine.impl.ExternalTaskQueryImpl;
import org.cibseven.bpm.engine.impl.ExternalTaskQueryProperty;
import org.cibseven.bpm.engine.impl.ProcessEngineImpl;
import org.cibseven.bpm.engine.impl.QueryOrderingProperty;
import org.cibseven.bpm.engine.impl.cfg.TransactionListener;
import org.cibseven.bpm.engine.impl.cfg.TransactionState;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.db.ListQueryParameterObject;
import org.cibseven.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.cibseven.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.AbstractManager;
import org.cibseven.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.SuspensionState;
import org.cibseven.bpm.engine.impl.util.ClockUtil;
import org.cibseven.bpm.engine.impl.util.DatabaseUtil;
import org.cibseven.bpm.engine.impl.util.ImmutablePair;

public class ExternalTaskManager
extends AbstractManager {
    public ExternalTaskEntity findExternalTaskById(String id) {
        return this.getDbEntityManager().selectById(ExternalTaskEntity.class, id);
    }

    public void insert(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().insert(externalTask);
        this.fireExternalTaskAvailableEvent();
    }

    public void delete(ExternalTaskEntity externalTask) {
        this.getDbEntityManager().delete(externalTask);
    }

    public List<ExternalTaskEntity> findExternalTasksByExecutionId(String id) {
        return this.getDbEntityManager().selectList("selectExternalTasksByExecutionId", id);
    }

    public List<ExternalTaskEntity> findExternalTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectExternalTasksByProcessInstanceId", processInstanceId);
    }

    public List<ExternalTaskEntity> selectExternalTasksForTopics(Collection<TopicFetchInstruction> queryFilters, int maxResults, List<QueryOrderingProperty> orderingProperties) {
        if (queryFilters.isEmpty()) {
            return Collections.emptyList();
        }
        boolean shouldApplyOrdering = !orderingProperties.isEmpty();
        Map<String, Boolean> parameters = Map.of("topics", queryFilters, "now", ClockUtil.getCurrentTime(), "applyOrdering", shouldApplyOrdering, "orderingProperties", orderingProperties, "usesPostgres", DatabaseUtil.checkDatabaseType("postgres"));
        ListQueryParameterObject parameter = new ListQueryParameterObject(parameters, 0, maxResults);
        this.configureQuery(parameter);
        DbEntityManager manager = this.getDbEntityManager();
        return manager.selectList("selectExternalTasksForTopics", parameter);
    }

    public List<ExternalTask> findExternalTasksByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskByQueryCriteria", externalTaskQuery);
    }

    public List<String> findExternalTaskIdsByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskIdsByQueryCriteria", externalTaskQuery);
    }

    public List<ImmutablePair<String, String>> findDeploymentIdMappingsByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectExternalTaskDeploymentIdMappingsByQueryCriteria", externalTaskQuery);
    }

    public long findExternalTaskCountByQueryCriteria(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return (Long)this.getDbEntityManager().selectOne("selectExternalTaskCountByQueryCriteria", externalTaskQuery);
    }

    public List<String> selectTopicNamesByQuery(ExternalTaskQueryImpl externalTaskQuery) {
        this.configureQuery(externalTaskQuery);
        return this.getDbEntityManager().selectList("selectTopicNamesByQuery", externalTaskQuery);
    }

    protected void updateExternalTaskSuspensionState(String processInstanceId, String processDefinitionId, String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateExternalTaskSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(processInstanceId, null, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, processDefinitionId, null, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        this.updateExternalTaskSuspensionState(null, null, processDefinitionKey, suspensionState);
    }

    public void updateExternalTaskSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExternalTaskEntity.class, "updateExternalTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void configureQuery(ExternalTaskQueryImpl query) {
        this.getAuthorizationManager().configureExternalTaskQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected void configureQuery(ListQueryParameterObject parameter) {
        this.getAuthorizationManager().configureExternalTaskFetch(parameter);
        this.getTenantManager().configureQuery(parameter);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    protected boolean shouldApplyOrdering(boolean usePriority, boolean useCreateTime) {
        return usePriority || useCreateTime;
    }

    protected boolean useCreateTime(List<QueryOrderingProperty> orderingProperties) {
        return orderingProperties.stream().anyMatch(orderingProperty -> ExternalTaskQueryProperty.CREATE_TIME.getName().equals(orderingProperty.getQueryProperty().getName()));
    }

    public void fireExternalTaskAvailableEvent() {
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, new TransactionListener(){

            @Override
            public void execute(CommandContext commandContext) {
                ProcessEngineImpl.EXT_TASK_CONDITIONS.signalAll();
            }
        });
    }
}

