/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.cibseven.bpm.engine.authorization.Permissions;
import org.cibseven.bpm.engine.authorization.Resources;
import org.cibseven.bpm.engine.filter.Filter;
import org.cibseven.bpm.engine.impl.AbstractQuery;
import org.cibseven.bpm.engine.impl.QueryValidators;
import org.cibseven.bpm.engine.impl.filter.FilterQueryImpl;
import org.cibseven.bpm.engine.impl.persistence.AbstractManager;
import org.cibseven.bpm.engine.impl.persistence.entity.FilterEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class FilterManager
extends AbstractManager {
    public Filter createNewFilter(String resourceType) {
        this.checkAuthorization(Permissions.CREATE, Resources.FILTER, "*");
        return new FilterEntity(resourceType);
    }

    public Filter insertOrUpdateFilter(Filter filter) {
        AbstractQuery query = (AbstractQuery)filter.getQuery();
        query.validate(QueryValidators.StoredQueryValidator.get());
        if (filter.getId() == null) {
            this.checkAuthorization(Permissions.CREATE, Resources.FILTER, "*");
            this.getDbEntityManager().insert((FilterEntity)filter);
            this.createDefaultAuthorizations(filter);
        } else {
            this.checkAuthorization(Permissions.UPDATE, Resources.FILTER, filter.getId());
            this.getDbEntityManager().merge((FilterEntity)filter);
        }
        return filter;
    }

    public void deleteFilter(String filterId) {
        this.checkAuthorization(Permissions.DELETE, Resources.FILTER, filterId);
        FilterEntity filter = this.findFilterByIdInternal(filterId);
        EnsureUtil.ensureNotNull("No filter found for filter id '" + filterId + "'", "filter", (Object)filter);
        this.deleteAuthorizations(Resources.FILTER, filterId);
        this.getDbEntityManager().delete(filter);
    }

    public FilterEntity findFilterById(String filterId) {
        EnsureUtil.ensureNotNull("Invalid filter id", "filterId", (Object)filterId);
        this.checkAuthorization(Permissions.READ, Resources.FILTER, filterId);
        return this.findFilterByIdInternal(filterId);
    }

    protected FilterEntity findFilterByIdInternal(String filterId) {
        return this.getDbEntityManager().selectById(FilterEntity.class, filterId);
    }

    public List<Filter> findFiltersByQueryCriteria(FilterQueryImpl filterQuery) {
        this.configureQuery(filterQuery, Resources.FILTER);
        return this.getDbEntityManager().selectList("selectFilterByQueryCriteria", filterQuery);
    }

    public long findFilterCountByQueryCriteria(FilterQueryImpl filterQuery) {
        this.configureQuery(filterQuery, Resources.FILTER);
        return (Long)this.getDbEntityManager().selectOne("selectFilterCountByQueryCriteria", filterQuery);
    }

    protected void createDefaultAuthorizations(Filter filter) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newFilter(filter));
        }
    }
}

