/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.cibseven.bpm.engine.ScriptCompilationException;
import org.cibseven.bpm.engine.ScriptEvaluationException;
import org.cibseven.bpm.engine.delegate.BpmnError;
import org.cibseven.bpm.engine.delegate.VariableScope;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.scripting.CompiledExecutableScript;
import org.cibseven.bpm.engine.impl.scripting.ScriptLogger;

public class SourceExecutableScript
extends CompiledExecutableScript {
    private static final ScriptLogger LOG = ProcessEngineLogger.SCRIPT_LOGGER;
    protected String scriptSource;
    protected boolean shouldBeCompiled = true;

    public SourceExecutableScript(String language, String source) {
        super(language);
        this.scriptSource = source;
    }

    @Override
    public Object evaluate(ScriptEngine engine, VariableScope variableScope, Bindings bindings) {
        if (this.shouldBeCompiled) {
            this.compileScript(engine);
        }
        if (this.getCompiledScript() != null) {
            return super.evaluate(engine, variableScope, bindings);
        }
        try {
            return this.evaluateScript(engine, bindings);
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof BpmnError) {
                throw (BpmnError)e.getCause();
            }
            String activityIdMessage = this.getActivityIdExceptionMessage(variableScope);
            throw new ScriptEvaluationException("Unable to evaluate script" + activityIdMessage + ":" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileScript(ScriptEngine engine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isEnableScriptEngineCaching() && processEngineConfiguration.isEnableScriptCompilation()) {
            if (this.getCompiledScript() == null && this.shouldBeCompiled) {
                SourceExecutableScript sourceExecutableScript = this;
                synchronized (sourceExecutableScript) {
                    if (this.getCompiledScript() == null && this.shouldBeCompiled) {
                        this.compiledScript = this.compile(engine, this.language, this.scriptSource);
                        this.shouldBeCompiled = false;
                    }
                }
            }
        } else {
            this.shouldBeCompiled = false;
        }
    }

    public CompiledScript compile(ScriptEngine scriptEngine, String language, String src) {
        if (scriptEngine instanceof Compilable && !scriptEngine.getFactory().getLanguageName().equalsIgnoreCase("ecmascript")) {
            Compilable compilingEngine = (Compilable)((Object)scriptEngine);
            try {
                CompiledScript compiledScript = compilingEngine.compile(src);
                LOG.debugCompiledScriptUsing(language);
                return compiledScript;
            }
            catch (ScriptException e) {
                throw new ScriptCompilationException("Unable to compile script: " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected Object evaluateScript(ScriptEngine engine, Bindings bindings) throws ScriptException {
        LOG.debugEvaluatingNonCompiledScript(this.scriptSource);
        return engine.eval(this.scriptSource, bindings);
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public void setScriptSource(String scriptSource) {
        this.compiledScript = null;
        this.shouldBeCompiled = true;
        this.scriptSource = scriptSource;
    }

    public boolean isShouldBeCompiled() {
        return this.shouldBeCompiled;
    }
}

