/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import java.lang.invoke.VarHandle;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

final class TruffleJDKServices {
    TruffleJDKServices() {
    }

    static void exportTo(ClassLoader loader, String moduleName) {
        assert (loader == null != (moduleName == null)) : "exactly one of a class loader or module name is required when exporting Truffle";
        Module truffleModule = TruffleJDKServices.class.getModule();
        Module clientModule = moduleName != null ? truffleModule.getLayer().findModule(moduleName).orElseThrow() : loader.getUnnamedModule();
        TruffleJDKServices.exportFromTo((Module)truffleModule, (Module)clientModule);
    }

    static void exportTo(Class<?> client) {
        Module truffleModule = TruffleJDKServices.class.getModule();
        TruffleJDKServices.exportFromTo((Module)truffleModule, (Module)client.getModule());
    }

    private static void exportFromTo(Module truffleModule, Module clientModule) {
        if (truffleModule != clientModule) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }

    static void addReads(Class<?> client) {
        Module truffleModule = TruffleJDKServices.class.getModule();
        Module clientModule = client.getModule();
        truffleModule.addReads(clientModule);
    }

    static <Service> List<Iterable<Service>> getTruffleRuntimeLoaders(Class<Service> serviceClass) {
        return Collections.singletonList(ServiceLoader.load(serviceClass));
    }

    static <S> void addUses(Class<S> service) {
        Module module = TruffleJDKServices.class.getModule();
        if (!module.canUse(service)) {
            module.addUses(service);
        }
    }

    static Object getUnnamedModule(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return classLoader.getUnnamedModule();
    }

    static boolean verifyModuleVisibility(Object module, Class<?> memberClass) {
        Module lookupModule = (Module)module;
        if (lookupModule == null) {
            return true;
        }
        Module memberModule = memberClass.getModule();
        if (lookupModule == memberModule) {
            return true;
        }
        String pkg = memberClass.getPackageName();
        if (lookupModule.isNamed()) {
            if (memberModule.isNamed()) {
                return memberModule.isExported(pkg, lookupModule);
            }
            return false;
        }
        if (memberModule.isNamed()) {
            return memberModule.isExported(pkg);
        }
        return true;
    }

    static boolean isNonTruffleClass(Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader truffleClassLoader = TruffleJDKServices.class.getModule().getClassLoader();
        return truffleClassLoader != (classLoader = clazz.getClassLoader());
    }

    static void fullFence() {
        VarHandle.fullFence();
    }

    static void acquireFence() {
        VarHandle.acquireFence();
    }

    static void releaseFence() {
        VarHandle.releaseFence();
    }

    static void loadLoadFence() {
        VarHandle.loadLoadFence();
    }

    static void storeStoreFence() {
        VarHandle.storeStoreFence();
    }
}

