/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

abstract class JSWriteCurrentFrameSlotNode
extends JSWriteFrameSlotNode {
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;

    protected JSWriteCurrentFrameSlotNode(FrameSlot frameSlot, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        super(frameSlot, frameDescriptor);
        this.rhsNode = rhsNode;
    }

    @Specialization(guards={"isBooleanKind(frame)"})
    protected final boolean doBoolean(VirtualFrame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"(isIntegerKind(frame, kind) || isLongKind(frame, kind)) || isDoubleKind(frame, kind)"})
    protected final int doInteger(VirtualFrame frame, int value, @Bind(value="frameDescriptor.getFrameSlotKind(frameSlot)") FrameSlotKind kind) {
        if (this.isIntegerKind(frame, kind)) {
            frame.setInt(this.frameSlot, value);
        } else if (this.isLongKind(frame, kind)) {
            frame.setLong(this.frameSlot, value);
        } else if (this.isDoubleKind(frame, kind)) {
            frame.setDouble(this.frameSlot, value);
        }
        return value;
    }

    @Specialization(guards={"isLongKind(frame)"})
    protected final SafeInteger doSafeInteger(VirtualFrame frame, SafeInteger value) {
        frame.setLong(this.frameSlot, value.longValue());
        return value;
    }

    @Specialization
    protected final long doLong(VirtualFrame frame, long value) {
        this.ensureObjectKind(frame);
        frame.setObject(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(frame)"}, replaces={"doInteger", "doSafeInteger"})
    protected final double doDouble(VirtualFrame frame, double value) {
        frame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(replaces={"doBoolean", "doInteger", "doDouble", "doSafeInteger", "doLong"})
    protected final Object doObject(VirtualFrame frame, Object value) {
        this.ensureObjectKind(frame);
        frame.setObject(this.frameSlot, value);
        return value;
    }

    @Override
    public final Object executeWithFrame(Frame frame, Object value) {
        return this.executeEvaluated((VirtualFrame)frame, value);
    }

    abstract Object executeEvaluated(VirtualFrame var1, Object var2);

    @Override
    public final Object executeWrite(VirtualFrame frame, Object value) {
        return this.executeEvaluated(frame, value);
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSWriteCurrentFrameSlotNodeGen.create(this.frameSlot, JSWriteCurrentFrameSlotNode.cloneUninitialized(this.getRhs(), materializedTags), this.frameDescriptor);
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return ScopeFrameNode.createCurrent();
    }
}

