/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSWriteScopeFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.TemporalDeadZoneCheckNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.Set;

public abstract class JSWriteFrameSlotNode
extends FrameSlotNode.WithDescriptor
implements WriteNode {
    protected JSWriteFrameSlotNode(FrameSlot frameSlot, FrameDescriptor frameDescriptor) {
        super(frameSlot, frameDescriptor);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.WriteVariableTag.class || tag == StandardTags.WriteVariableTag.class) {
            return !JSFrameUtil.isInternal(this.frameSlot);
        }
        if (tag == JSTags.InputNodeTag.class) {
            return !JSFrameUtil.isInternal(this.frameSlot);
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        String name = JSFrameUtil.getPublicName(this.frameSlot);
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", name);
        descriptor.addProperty("writeVariableName", name);
        return descriptor;
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if ((materializedTags.contains(JSTags.WriteVariableTag.class) || materializedTags.contains(StandardTags.WriteVariableTag.class)) && this.getRhs() != null && !this.getRhs().hasSourceSection() && this.hasSourceSection()) {
            JSWriteFrameSlotNode.transferSourceSectionAddExpressionTag(this, this.getRhs());
        }
        return this;
    }

    @Override
    public abstract JavaScriptNode getRhs();

    public abstract Object executeWithFrame(Frame var1, Object var2);

    public static JSWriteFrameSlotNode create(FrameSlot frameSlot, FrameDescriptor frameDescriptor, JavaScriptNode rhs, boolean hasTemporalDeadZone) {
        if (!hasTemporalDeadZone) {
            return JSWriteCurrentFrameSlotNodeGen.create(frameSlot, rhs, frameDescriptor);
        }
        return JSWriteFrameSlotNode.create(frameSlot, ScopeFrameNode.createCurrent(), rhs, frameDescriptor, hasTemporalDeadZone);
    }

    public static JSWriteFrameSlotNode create(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhs, FrameDescriptor frameDescriptor, boolean hasTemporalDeadZone) {
        if (!hasTemporalDeadZone && scopeFrameNode == ScopeFrameNode.createCurrent()) {
            return JSWriteCurrentFrameSlotNodeGen.create(frameSlot, rhs, frameDescriptor);
        }
        return JSWriteScopeFrameSlotNodeGen.create(frameSlot, scopeFrameNode, hasTemporalDeadZone ? TemporalDeadZoneCheckNode.create(frameSlot, scopeFrameNode, rhs) : rhs, frameDescriptor);
    }

    @Override
    public final boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.getRhs().isResultAlwaysOfType(clazz);
    }
}

