/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RealmNode;
import com.oracle.truffle.js.nodes.arguments.ArgumentsObjectNodeGen;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class ArgumentsObjectNode
extends JavaScriptNode {
    private final boolean strict;
    @Node.Child
    private RealmNode realmNode;
    private final int leadingArgCount;
    private final int trailingArgCount;
    @Node.Child
    private DynamicObjectLibrary putLengthNode;
    @Node.Child
    private DynamicObjectLibrary putSymbolIteratorNode;
    @Node.Child
    private DynamicObjectLibrary putCalleeNode;
    @Node.Child
    private DynamicObjectLibrary putCallerNode;
    private static final int THROWER_ACCESSOR_PROPERTY_FLAGS = JSAttributes.notConfigurableNotEnumerable() | 8;

    protected ArgumentsObjectNode(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        this.strict = strict;
        this.realmNode = RealmNode.create(context);
        this.leadingArgCount = leadingArgCount;
        this.trailingArgCount = trailingArgCount;
        this.putLengthNode = JSObjectUtil.createDispatched("length");
        this.putSymbolIteratorNode = JSObjectUtil.createDispatched(Symbol.SYMBOL_ITERATOR);
        this.putCalleeNode = JSObjectUtil.createDispatched("callee");
    }

    public static JavaScriptNode create(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        return ArgumentsObjectNodeGen.create(context, strict, leadingArgCount, trailingArgCount);
    }

    protected final boolean isStrict(VirtualFrame frame) {
        assert (this.strict == JSFunction.isStrict(ArgumentsObjectNode.getFunctionObject(frame)) || this.strict);
        return this.strict;
    }

    @Specialization(guards={"isStrict(frame)"})
    protected DynamicObject doStrict(VirtualFrame frame) {
        Object[] arguments = this.getObjectArray(frame);
        JSContext context = this.realmNode.getContext();
        JSRealm realm = this.realmNode.execute(frame);
        JSObjectFactory factory = context.getStrictArgumentsFactory();
        JSArgumentsObject.Unmapped argumentsObject = JSArgumentsArray.createUnmapped(factory.getShape(realm), arguments);
        factory.initProto(argumentsObject, realm);
        this.putLengthNode.putWithFlags(argumentsObject, "length", arguments.length, JSAttributes.getDefaultNotEnumerable());
        this.putSymbolIteratorNode.putWithFlags(argumentsObject, Symbol.SYMBOL_ITERATOR, realm.getArrayProtoValuesIterator(), JSAttributes.getDefaultNotEnumerable());
        this.putCalleeNode.putWithFlags(argumentsObject, "callee", realm.getThrowerAccessor(), THROWER_ACCESSOR_PROPERTY_FLAGS);
        if (realm.getContext().getEcmaScriptVersion() < 8) {
            if (this.putCallerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.putCallerNode = this.insert(JSObjectUtil.createDispatched("caller"));
            }
            this.putCallerNode.putWithFlags(argumentsObject, "caller", realm.getThrowerAccessor(), THROWER_ACCESSOR_PROPERTY_FLAGS);
        }
        return context.trackAllocation(argumentsObject);
    }

    @Specialization(guards={"!isStrict(frame)"})
    protected DynamicObject doNonStrict(VirtualFrame frame) {
        Object[] arguments = this.getObjectArray(frame);
        JSContext context = this.realmNode.getContext();
        JSRealm realm = this.realmNode.execute(frame);
        DynamicObject callee = ArgumentsObjectNode.getFunctionObject(frame);
        JSObjectFactory factory = context.getNonStrictArgumentsFactory();
        JSArgumentsObject.Mapped argumentsObject = JSArgumentsArray.createMapped(factory.getShape(realm), arguments);
        factory.initProto(argumentsObject, realm);
        this.putLengthNode.putWithFlags(argumentsObject, "length", arguments.length, JSAttributes.getDefaultNotEnumerable());
        this.putSymbolIteratorNode.putWithFlags(argumentsObject, Symbol.SYMBOL_ITERATOR, realm.getArrayProtoValuesIterator(), JSAttributes.getDefaultNotEnumerable());
        this.putCalleeNode.putWithFlags(argumentsObject, "callee", callee, JSAttributes.getDefaultNotEnumerable());
        return context.trackAllocation(argumentsObject);
    }

    private static DynamicObject getFunctionObject(VirtualFrame frame) {
        return (DynamicObject)JSArguments.getFunctionObject(frame.getArguments());
    }

    public Object[] getObjectArray(VirtualFrame frame) {
        return JSArguments.extractUserArguments(frame.getArguments(), this.leadingArgCount, this.trailingArgCount);
    }

    static boolean isInitialized(Object argumentsArray) {
        return argumentsArray != Undefined.instance;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ArgumentsObjectNodeGen.create(this.realmNode.getContext(), this.strict, this.leadingArgCount, this.trailingArgCount);
    }
}

