/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.control.YieldNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

class YieldStarNode
extends YieldNode {
    @Node.Child
    private GetIteratorNode getIteratorNode;
    @Node.Child
    private IteratorNextNode iteratorNextNode;
    @Node.Child
    private IteratorCompleteNode iteratorCompleteNode;
    @Node.Child
    private IteratorValueNode iteratorValueNode;
    @Node.Child
    private GetMethodNode getThrowMethodNode;
    @Node.Child
    private GetMethodNode getReturnMethodNode;
    @Node.Child
    private JSFunctionCallNode callThrowNode;
    @Node.Child
    private JSFunctionCallNode callReturnNode;
    @Node.Child
    private IteratorCloseNode iteratorCloseNode;
    private final ConditionProfile returnOrExceptionProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorBranch = BranchProfile.create();

    protected YieldStarNode(JSContext context, JavaScriptNode expression, JavaScriptNode yieldValue, ReturnNode returnNode, JSWriteFrameSlotNode writeYieldResultNode) {
        super(context, expression, yieldValue, returnNode, writeYieldResultNode);
        this.getIteratorNode = GetIteratorNode.create(context);
        this.iteratorNextNode = IteratorNextNode.create();
        this.iteratorCompleteNode = IteratorCompleteNode.create(context);
        this.iteratorValueNode = IteratorValueNode.create(context, null);
        this.getThrowMethodNode = GetMethodNode.create(context, null, "throw");
        this.getReturnMethodNode = GetMethodNode.create(context, null, "return");
        this.callThrowNode = JSFunctionCallNode.createCall();
        this.callReturnNode = JSFunctionCallNode.createCall();
        this.iteratorCloseNode = IteratorCloseNode.create(context);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JSDynamicObject received;
        IteratorRecord iteratorRecord = this.getIteratorNode.execute(this.expression.execute(frame));
        Object innerResult = this.iteratorNextNode.execute(iteratorRecord, received = Undefined.instance);
        if (this.iteratorCompleteNode.execute(innerResult)) {
            return this.iteratorValueNode.execute(innerResult);
        }
        return this.saveStateAndYield(frame, iteratorRecord, innerResult);
    }

    private Object saveStateAndYield(VirtualFrame frame, IteratorRecord iteratorRecord, Object innerResult) {
        this.setState(frame, iteratorRecord);
        return this.generatorYield(frame, innerResult);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        Object state = this.getState(frame);
        if (state == Undefined.instance) {
            return this.execute(frame);
        }
        this.resetState(frame);
        IteratorRecord iteratorRecord = (IteratorRecord)state;
        Object received = this.yieldValue.execute(frame);
        if (!(received instanceof Completion)) {
            Object innerResult = this.iteratorNextNode.execute(iteratorRecord, received);
            if (this.iteratorCompleteNode.execute(innerResult)) {
                return this.iteratorValueNode.execute(innerResult);
            }
            return this.saveStateAndYield(frame, iteratorRecord, innerResult);
        }
        Completion completion = (Completion)received;
        received = completion.getValue();
        if (this.returnOrExceptionProfile.profile(completion.isThrow())) {
            return this.resumeThrow(frame, iteratorRecord, received);
        }
        assert (completion.isReturn());
        return this.resumeReturn(frame, iteratorRecord, received);
    }

    private Object resumeReturn(VirtualFrame frame, IteratorRecord iteratorRecord, Object received) {
        DynamicObject iterator = iteratorRecord.getIterator();
        Object returnMethod = this.getReturnMethodNode.executeWithTarget(iterator);
        if (returnMethod == Undefined.instance) {
            return this.returnValue(frame, received);
        }
        DynamicObject innerReturnResult = this.callReturnMethod(iterator, received, returnMethod);
        if (this.iteratorCompleteNode.execute(innerReturnResult)) {
            return this.returnValue(frame, this.iteratorValueNode.execute(innerReturnResult));
        }
        return this.saveStateAndYield(frame, iteratorRecord, innerReturnResult);
    }

    private Object resumeThrow(VirtualFrame frame, IteratorRecord iteratorRecord, Object received) {
        DynamicObject iterator = iteratorRecord.getIterator();
        Object throwMethod = this.getThrowMethodNode.executeWithTarget(iterator);
        if (throwMethod != Undefined.instance) {
            DynamicObject innerResult = this.callThrowMethod(iterator, received, throwMethod);
            if (this.iteratorCompleteNode.execute(innerResult)) {
                return this.iteratorValueNode.execute(innerResult);
            }
            return this.saveStateAndYield(frame, iteratorRecord, innerResult);
        }
        this.errorBranch.enter();
        this.iteratorCloseNode.executeVoid(iterator);
        throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
    }

    private DynamicObject callThrowMethod(DynamicObject iterator, Object received, Object throwMethod) {
        Object innerResult = this.callThrowNode.executeCall(JSArguments.createOneArg(iterator, throwMethod, received));
        if (!JSRuntime.isObject(innerResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
        return (DynamicObject)innerResult;
    }

    private DynamicObject callReturnMethod(DynamicObject iterator, Object received, Object returnMethod) {
        Object innerResult = this.callReturnNode.executeCall(JSArguments.createOneArg(iterator, returnMethod, received));
        if (!JSRuntime.isObject(innerResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
        return (DynamicObject)innerResult;
    }
}

