/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSInteropCallNode
extends JavaScriptBaseNode {
    protected JSInteropCallNode() {
    }

    protected static Object[] prepare(Object[] arguments, ImportValueNode importValueNode) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = importValueNode.executeWithTarget(arguments[i]);
        }
        return arguments;
    }

    protected static PropertyGetNode getUncachedProperty() {
        return null;
    }

    protected static Object getProperty(JSObject receiver, PropertyGetNode propertyGetNode, Object key, Object defaultValue) {
        Object method;
        assert (JSRuntime.isPropertyKey(key));
        if (propertyGetNode == null) {
            method = JSObject.getOrDefault((DynamicObject)receiver, key, (Object)receiver, defaultValue);
        } else {
            assert (JSRuntime.propertyKeyEquals(propertyGetNode.getKey(), key));
            method = propertyGetNode.getValueOrDefault(receiver, defaultValue);
        }
        return method;
    }
}

