/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.ibm.icu.text.BreakIterator;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;

public class CreateSegmentDataObjectNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    CreateDataPropertyNode createSegmentPropertyNode;
    @Node.Child
    CreateDataPropertyNode createIndexPropertyNode;
    @Node.Child
    CreateDataPropertyNode createInputPropertyNode;
    @Node.Child
    CreateDataPropertyNode createIsWordLikePropertyNode;

    protected CreateSegmentDataObjectNode(JSContext context) {
        this.context = context;
        this.createSegmentPropertyNode = CreateDataPropertyNode.create(context, "segment");
        this.createIndexPropertyNode = CreateDataPropertyNode.create(context, "index");
        this.createInputPropertyNode = CreateDataPropertyNode.create(context, "input");
    }

    public static CreateSegmentDataObjectNode create(JSContext context) {
        return new CreateSegmentDataObjectNode(context);
    }

    public DynamicObject execute(BreakIterator icuIterator, JSSegmenter.Granularity granularity, String string, int startIndex, int endIndex) {
        DynamicObject result = JSOrdinary.create(this.context, this.getRealm());
        this.createSegmentPropertyNode.executeVoid(result, Boundaries.substring(string, startIndex, endIndex));
        this.createIndexPropertyNode.executeVoid(result, startIndex);
        this.createInputPropertyNode.executeVoid(result, string);
        if (granularity == JSSegmenter.Granularity.WORD) {
            this.createIsWordLikeProperty(result, CreateSegmentDataObjectNode.isWordLike(icuIterator));
        }
        return result;
    }

    private void createIsWordLikeProperty(DynamicObject target, boolean isWordLike) {
        if (this.createIsWordLikePropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.createIsWordLikePropertyNode = this.insert(CreateDataPropertyNode.create(this.context, "isWordLike"));
        }
        this.createIsWordLikePropertyNode.executeVoid(target, isWordLike);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isWordLike(BreakIterator icuIterator) {
        return icuIterator.getRuleStatus() != 0;
    }
}

