/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.PromiseRejectionTracker;
import java.io.PrintWriter;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;

public class BuiltinPromiseRejectionTracker
implements PromiseRejectionTracker {
    private final JSContext context;
    private final JSContextOptions.UnhandledRejectionsTrackingMode mode;
    private final Set<DynamicObject> pendingUnhandledRejections = new LinkedHashSet<DynamicObject>();
    private final Deque<PromiseChainInfoRecord> asyncHandledRejections = new LinkedList<PromiseChainInfoRecord>();
    private final Map<DynamicObject, PromiseChainInfoRecord> maybeUnhandledPromises = new WeakHashMap<DynamicObject, PromiseChainInfoRecord>();

    public BuiltinPromiseRejectionTracker(JSContext context, JSContextOptions.UnhandledRejectionsTrackingMode mode) {
        assert (mode != JSContextOptions.UnhandledRejectionsTrackingMode.NONE);
        this.context = context;
        this.mode = mode;
    }

    @Override
    public void promiseRejected(DynamicObject promise, Object reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.maybeUnhandledPromises.put(promise, new PromiseChainInfoRecord(reason, false));
        this.pendingUnhandledRejections.add(promise);
        this.context.getLanguage().getPromiseJobsQueueEmptyAssumption().invalidate("Potential unhandled rejection");
    }

    @Override
    public void promiseRejectionHandled(DynamicObject promise) {
        CompilerAsserts.neverPartOfCompilation();
        PromiseChainInfoRecord promiseInfo = this.maybeUnhandledPromises.get(promise);
        if (promiseInfo != null) {
            this.maybeUnhandledPromises.remove(promise);
            this.pendingUnhandledRejections.remove(promise);
            if (promiseInfo.warned) {
                this.asyncHandledRejections.add(promiseInfo);
            }
        }
    }

    @Override
    public void promiseRejectedAfterResolved(DynamicObject promise, Object value) {
    }

    @Override
    public void promiseResolvedAfterResolved(DynamicObject promise, Object value) {
    }

    @Override
    public void promiseReactionJobsProcessed() {
        CompilerAsserts.neverPartOfCompilation();
        JSRealm realm = JSRealm.get(null);
        assert (realm.getContext() == this.context);
        while (!this.asyncHandledRejections.isEmpty()) {
            PromiseChainInfoRecord info = this.asyncHandledRejections.removeFirst();
            if (this.mode != JSContextOptions.UnhandledRejectionsTrackingMode.WARN) continue;
            PrintWriter out = realm.getErrorWriter();
            out.println("[GraalVM JavaScript Warning] Promise rejection was handled asynchronously: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
            out.flush();
        }
        while (!this.pendingUnhandledRejections.isEmpty()) {
            DynamicObject unhandledPromise = this.pendingUnhandledRejections.iterator().next();
            this.pendingUnhandledRejections.remove(unhandledPromise);
            PromiseChainInfoRecord info = this.maybeUnhandledPromises.get(unhandledPromise);
            if (info == null) continue;
            info.warned = true;
            if (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.WARN) {
                PrintWriter out = realm.getErrorWriter();
                out.println("[GraalVM JavaScript Warning] Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
                out.flush();
                continue;
            }
            assert (this.mode == JSContextOptions.UnhandledRejectionsTrackingMode.THROW);
            InteropLibrary interop = InteropLibrary.getUncached(info.reason);
            if (interop.isException(info.reason)) {
                try {
                    interop.throwException(info.reason);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw Errors.createError("Unhandled promise rejection: " + BuiltinPromiseRejectionTracker.formatError(info.reason));
        }
    }

    private static String formatError(Object error) {
        block8: {
            CompilerAsserts.neverPartOfCompilation();
            InteropLibrary interopExc = InteropLibrary.getUncached(error);
            InteropLibrary interopStr = InteropLibrary.getUncached();
            if (interopExc.isException(error)) {
                try {
                    String message = null;
                    if (interopExc.hasExceptionMessage(error)) {
                        message = interopStr.asString(interopExc.getExceptionMessage(error));
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Optional.ofNullable(message).orElse("Error"));
                    if (interopExc.hasExceptionStackTrace(error)) {
                        Object stackTrace = interopExc.getExceptionStackTrace(error);
                        InteropLibrary interopST = InteropLibrary.getUncached(stackTrace);
                        long length = interopST.getArraySize(stackTrace);
                        for (long i = 0L; i < length; ++i) {
                            Object stackTraceElement = interopST.readArrayElement(stackTrace, i);
                            InteropLibrary interopSTE = InteropLibrary.getUncached(stackTraceElement);
                            String name = null;
                            SourceSection sourceLocation = null;
                            if (interopSTE.hasExecutableName(stackTraceElement)) {
                                name = interopStr.asString(interopSTE.getExecutableName(stackTraceElement));
                            }
                            if (interopSTE.hasSourceLocation(stackTraceElement)) {
                                sourceLocation = interopSTE.getSourceLocation(stackTraceElement);
                            }
                            if (name == null && sourceLocation == null) continue;
                            sb.append('\n');
                            sb.append("    at ");
                            sb.append(Optional.ofNullable(name).orElse("<anonymous>"));
                            if (sourceLocation == null) continue;
                            sb.append(" (").append(BuiltinPromiseRejectionTracker.formatSourceLocation(sourceLocation)).append(")");
                        }
                    }
                    return sb.toString();
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return JSRuntime.safeToString(error).toString();
    }

    private static String formatSourceLocation(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "Unknown";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sourceSection.getSource().getName());
        sb.append(":");
        sb.append(sourceSection.getStartLine());
        if (sourceSection.getStartLine() < sourceSection.getEndLine()) {
            sb.append("-").append(sourceSection.getEndLine());
        }
        sb.append(":");
        sb.append(sourceSection.getCharIndex());
        if (sourceSection.getCharLength() > 1) {
            sb.append("-").append(sourceSection.getCharEndIndex() - 1);
        }
        return sb.toString();
    }

    private static class PromiseChainInfoRecord {
        private final Object reason;
        private boolean warned;

        PromiseChainInfoRecord(Object reason, boolean warned) {
            this.reason = reason;
            this.warned = warned;
        }
    }
}

