/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.interop.JSMetaType;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public final class Symbol
implements TruffleObject {
    public static final Symbol SYMBOL_HAS_INSTANCE = Symbol.create("Symbol.hasInstance");
    public static final Symbol SYMBOL_IS_CONCAT_SPREADABLE = Symbol.create("Symbol.isConcatSpreadable");
    public static final Symbol SYMBOL_ITERATOR = Symbol.create("Symbol.iterator");
    public static final Symbol SYMBOL_ASYNC_ITERATOR = Symbol.create("Symbol.asyncIterator");
    public static final Symbol SYMBOL_MATCH = Symbol.create("Symbol.match");
    public static final Symbol SYMBOL_MATCH_ALL = Symbol.create("Symbol.matchAll");
    public static final Symbol SYMBOL_REPLACE = Symbol.create("Symbol.replace");
    public static final Symbol SYMBOL_SEARCH = Symbol.create("Symbol.search");
    public static final Symbol SYMBOL_SPECIES = Symbol.create("Symbol.species");
    public static final Symbol SYMBOL_SPLIT = Symbol.create("Symbol.split");
    public static final Symbol SYMBOL_TO_PRIMITIVE = Symbol.create("Symbol.toPrimitive");
    public static final Symbol SYMBOL_TO_STRING_TAG = Symbol.create("Symbol.toStringTag");
    public static final Symbol SYMBOL_UNSCOPABLES = Symbol.create("Symbol.unscopables");
    private final String description;
    private final boolean registered;

    private Symbol(String description, boolean registered) {
        this.description = description;
        this.registered = registered;
    }

    public static Symbol create(String description) {
        return new Symbol(description, false);
    }

    public static Symbol createRegistered(String description) {
        return new Symbol(Objects.requireNonNull(description), true);
    }

    public Object getDescription() {
        return this.description == null ? Undefined.instance : this.description;
    }

    public String getName() {
        return this.description == null ? "" : this.description;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "Symbol(" + this.getName() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public String toFunctionNameString() {
        return this.description == null ? "" : '[' + this.description + ']';
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return JSMetaType.JS_SYMBOL;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    int identityHashCode() {
        return super.hashCode();
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(Symbol receiver, Symbol other) {
            return TriState.valueOf(receiver == other);
        }

        @Fallback
        static TriState doOther(Symbol receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

