/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.MapPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSMapObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class JSMap
extends JSNonProxy
implements JSConstructorFactory.Default.WithSpecies,
PrototypeSupplier {
    public static final JSMap INSTANCE = new JSMap();
    public static final String CLASS_NAME = "Map";
    public static final String PROTOTYPE_NAME = "Map.prototype";
    public static final String ITERATOR_CLASS_NAME = "Map Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Map Iterator.prototype";
    private static final String SIZE = "size";
    public static final HiddenKey MAP_ITERATION_KIND_ID = new HiddenKey("MapIterationKind");

    private JSMap() {
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getMapFactory();
        JSMapObject obj = factory.initProto(new JSMapObject(factory.getShape(realm), new JSHashMap()), realm);
        assert (JSMap.isJSMap(obj));
        return context.trackAllocation(obj);
    }

    public static JSHashMap getInternalMap(DynamicObject obj) {
        assert (JSMap.isJSMap(obj));
        return ((JSMapObject)obj).getMap();
    }

    public static int getMapSize(DynamicObject obj) {
        assert (JSMap.isJSMap(obj));
        return JSMap.getInternalMap(obj).size();
    }

    private static DynamicObject createSizeGetterFunction(JSRealm realm) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.MapGetSize, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(c.getLanguage(), null, null){
                private final BranchProfile errorBranch = BranchProfile.create();

                @Override
                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSMap.isJSMap(obj)) {
                        return JSMap.getMapSize((DynamicObject)obj);
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeErrorMapExpected();
                }
            });
            return JSFunctionData.createCallOnly(c, callTarget, 0, "get size");
        });
        DynamicObject sizeGetter = JSFunction.create(realm, getterData);
        return sizeGetter;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)SIZE, JSMap.createSizeGetterFunction(realm), Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, MapPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        Object entriesFunction = JSDynamicObject.getOrNull(prototype, "entries");
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_ITERATOR, entriesFunction, JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return "[" + this.getClassName() + "]";
        }
        JSHashMap map = JSMap.getInternalMap(obj);
        return JSRuntime.collectionToConsoleString(obj, this.getClassName(obj), map, depth, allowSideEffects);
    }

    public static boolean isJSMap(Object obj) {
        return obj instanceof JSMapObject;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getMapPrototype();
    }
}

