/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.WeakSetPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSWeakSetObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.Map;
import java.util.WeakHashMap;

public final class JSWeakSet
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWeakSet INSTANCE = new JSWeakSet();
    public static final String CLASS_NAME = "WeakSet";
    public static final String PROTOTYPE_NAME = "WeakSet.prototype";

    private JSWeakSet() {
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getWeakSetFactory();
        JSWeakSetObject obj = factory.initProto(new JSWeakSetObject(factory.getShape(realm), JSWeakSet.newWeakHashMap()), realm);
        assert (JSWeakSet.isJSWeakSet(obj));
        return context.trackAllocation(obj);
    }

    @CompilerDirectives.TruffleBoundary
    private static Map<Object, Object> newWeakHashMap() {
        return new WeakHashMap<Object, Object>();
    }

    public static Map<Object, Object> getInternalWeakMap(DynamicObject obj) {
        assert (JSWeakSet.isJSWeakSet(obj));
        return ((JSWeakSetObject)obj).getWeakHashMap();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WeakSetPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return "[" + this.getClassName() + "]";
        }
        return this.getClassName();
    }

    public static boolean isJSWeakSet(Object obj) {
        return obj instanceof JSWeakSetObject;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWeakSetPrototype();
    }
}

